<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_Cache.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 硬盘文件缓存类，将需要缓存的内容，保存在硬盘的某个文件上。
 * 如果能够将 内存 挂在到文件系统，此类同样可用于 实现 内存缓存
 *
 * @author		alee
 * @access		public
 */
class JCAT_Cache
{

	/**
	 * 注册一个 函数(方法)，用户取得系统缺省的 JCAT_ICache 对象
	 *
	 * @access	public
	 * @param	$Callback
	 * @static
	 * @return	old
	 */
	static public function RegisterCallbackForDefaultCache($Callback)
	{
		JCAT_ASSERT::ASSERT_ISTHESE($Callback,array('callback','null'))  ;
		
		$old_value = self::$CallbackForDefaultCache ;
		self::$CallbackForDefaultCache = $Callback ;
		return $old_value ;
	}
	
	/**
	 * 取得一个缺省的 JCAT_ICache 对象
	 *
	 * @access	public
	 * @param	$Parameter
	 * @static
	 * @return	JCAT_ICache
	 */
	static public function GetDefaultCache()
	{
		JCAT_ASSERT::ASSERT_( self::$CallbackForDefaultCache
				, JCAT_Language::SentenceEx('尚未调用 JCAT_Cache::RegisterCallbackForDefaultCache()','JCAT',null) ) ;
		
		$aCache = call_user_func(self::$CallbackForDefaultCache) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aCache,'JCAT_ICache'
			, JCAT_Language::SentenceEx('JCAT_Cache::RegisterCallbackForDefaultCache() 设置的函数必须返回一个 JCAT_ICache 对象','JCAT',null));
		
		return $aCache ;
	}



	// 属性 ///////////////////////////////////////////////////////////////////////////////

	static private $CallbackForDefaultCache ;

}
?>