<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_HDCache.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/





/**
 * 硬盘文件缓存类，将需要缓存的内容，保存在硬盘的某个文件上。
 * 如果能够将 内存 挂在到文件系统，此类同样可用于 实现 内存缓存
 *
 * @author		alee
 * @access		public
 */
class JCAT_HDCache implements JCAT_ICache
{


	/**
	 * 
	 * @access	public
	 * @param	$sCacheDir		string	存放缓存文件的目录
	 * @param	$bCreate=true	bool	如果此目录 不存在，是否自动创建
	 * @return	void
	 */
	public function JCAT_HDCache( $sCacheDir, $bCreate=true ) 
	{
		JCAT_ASSERT::ASSERT_STRING($sCacheDir) ;
		JCAT_ASSERT::ASSERT_BOOL($bCreate) ;		
		JCAT_ASSERT::ASSERT_( !is_file($sCacheDir), JCAT_Language::SentenceEx('路径是一个已经存在的文件，无法用作缓存目录： “%s” 。','JCAT',null,$sCacheDir) ) ;
		
		if( !file_exists($sCacheDir) )
			JCAT_ASSERT::ASSERT_(mkdir($sCacheDir,0777,true),JCAT_Language::SentenceEx('无法创建缓存目录：“%s”','JCAT',null,$sCacheDir) ) ;
		
		JCAT_ASSERT::ASSERT_DIR($sCacheDir) ;
		
		$this->sCacheDir = $sCacheDir ;		
	}



	/**
	 * 取回缓存目录的路径
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetCacheDir() 
	{ return $this->sCacheDir ; }

	/**
	 * 给定一个有效时长，检查缓存项目有没有过期
	 * 
	 * @access	public
	 * @param	$sCacheName	string	缓存项目 的名称
	 * @param	$nSec=0		int		有效时长,单位是秒；如果为0，则只要该项目存在即有效
	 * @return	bool
	 */
	public function IsExpired( $sCacheName, $nSec=0 )
	{
		JCAT_ASSERT::ASSERT_STRING($sCacheName) ;
		JCAT_ASSERT::ASSERT_INT($nSec) ;

		$nCacheTime = $this->GetCacheTime($sCacheName) ;
		
		if( $nCacheTime>0 and $nSec==0)
		{
			return true ;
		}
		
		return ($nCacheTime+$nSec < time()) ;
	}



	/**
	 * 设置缓存内容
	 * 
	 * @access	public
	 * @param	$sCacheName	string	缓存项目名称
	 * @param	$sValue		string	缓存内容
	 * @return	bool
	 */
	public function Set( $sCacheName, $sValue )
	{
		JCAT_ASSERT::ASSERT_STRING($sCacheName) ;
		JCAT_ASSERT::ASSERT_STRING($sValue) ;
		JCAT_ASSERT::ASSERT_DIR($this->sCacheDir) ;
		
		$sCachePath = "{$this->sCacheDir}/{$sCacheName}" ;
		file_put_contents($sCachePath,$sValue) ;
		
		return is_file($sCachePath) ;
	}



	/**
	 * 取回缓存内容，如果 过期或不存在，返回 null
	 * 
	 * @access	public
	 * @param	$sCacheName			string	缓存名称
	 * @param	$nExpiredSec=0		int		有效时长,单位是秒；如果为0，则只要该项目存在即有效
	 * @return	string,null
	 */
	public function Get( $sCacheName, $nExpiredSec=0 )
	{
		JCAT_ASSERT::ASSERT_STRING($sCacheName) ;
		JCAT_ASSERT::ASSERT_INT($nExpiredSec) ;
		
		if( $nExpiredSec>0 and $this->IsExpired($sCacheName,$nExpiredSec) )
		{
			return null ;
		}
		
		$sCacheFile = $this->GetCacheDir().'/'.$sCacheName ;
		return file_get_contents($sCacheFile) ;
	}



	/**
	 * 删除缓存项目
	 * 
	 * @access	public
	 * @param	$sCacheName			string	缓存项目名称
	 * @return	bool
	 */
	public function Delete( $sCacheName )
	{
		$sCacheFile = $this->GetCacheDir().'/'.$sCacheName ;
		return unlink($sCacheFile) ;
	}


	/**
	 * 取得缓存时间
	 * 
	 * @access	public
	 * @param	$sCacheName			string	缓存项目名称
	 * @return	int
	 */
	public function GetCacheTime($sCacheName)
	{
		$sCacheFile = $this->GetCacheDir().'/'.$sCacheName ;
		return is_file($sCacheFile)?
			 filemtime($sCacheFile): 0 ;
	}
	

	// 属性 ///////////////////////////////////////////////////////////////////////////////

	private $sCacheDir ;

}
?>