<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBConnect.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 所有数据库连接类 的基类
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_DBConnect
{
	/**
	 * 连接数据库服务器
	 * 
	 * @access	public
	 * @param	$sHost='localhost'	string	数据库主机名
	 * @param	$sUser=''			string	用户名，缺省使用当前用户（Linux）
	 * @param	$sPassword=''		string	密码
	 * @param	$bPersistent=false	bool	持久连接
	 * @return	bool
	 */
	abstract public function Connect(  $sHost='localhost',  $sUser='',  $sPassword='',  $bPersistent=false ) ;



	/**
	 * 断开连接
	 * 
	 * @access	public
	 * @return	bool
	 */
	abstract public function Disconnect() ;

	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	abstract public function IsConnected() ;

	/**
	 * 设置一个数据库连接句柄到对象中
	 * 
	 * @access	public
	 * @param	$hConnectHandle		handle	数据库连接句柄
	 * @return	old_value
	 */
	public function SetConnectHandle( $hConnectHandle ) 
	{
		JCAT_ASSERT::ASSERT_ISTHESE($hConnectHandle,array('handle'),JCAT_Language::SentenceEx('参数 $hConnectHandle 必须是有效的数据库连接','JCAT',null)) ;
		
		$old_value = $this->hConnectHandle ;
		$this->hConnectHandle = $hConnectHandle ;
		return $old_value ;
	}



	/**
	 * 返回当前的数据库连接句柄
	 * 
	 * @access	public
	 * @return	handle
	 */
	public function GetConnectHandle() 
	{ return $this->hConnectHandle ; }



	/**
	 * 执行一段SQL语句
	 * 
	 * @access	public
	 * @param	$SQL		GENERIC_SQL	SQL语句
	 * @param	$sDB=null	string		指定数据库 库名
	 * @return	
	 */
	abstract public function Query( $SQL, $sDB='', $bSaveSQL=true ) ;

	
	/**
	 * get count of select result
	 * 
	 * @access	public
	 * @param	$aSQL			JCAT_DBSQLSelect	SQL语句
	 * @param	$sDB=null	string				指定数据库 库名
	 * @return	
	 */
	abstract public function GetSelectCount( JCAT_DBSQLSelect $aSQL, $sDB='' ) ;

	/**
	 * 返回刚刚插入的行的主键值
	 * 
	 * @access	public
	 * @return	int
	 */
	abstract public function GetInsertID() ;

	/**
	 * 开始事务
	 * 
	 * @access	public
	 * @return	bool
	 */
	abstract public function StartTransaction() ;



	/**
	 * 提交事务中的操作
	 * 
	 * @access	public
	 * @return	bool
	 */
	abstract public function Commit() ;



	/**
	 * 放弃事务中的操作
	 * 
	 * @access	public
	 * @return	bool
	 */
	abstract public function Rollback() ;


	/**
	 * 放弃事务中的操作
	 * 
	 * @access	public
	 * @return	JCAT_IDBReflector
	 */
	public function GetDBReflector()
	{
		return $this->aDBReflector ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @param	$aDBReflector	JCAT_IDBReflector
	 * @return	void
	 */
	protected function SetDBReflector(JCAT_IDBReflector $aDBReflector)
	{
		$this->aDBReflector = $aDBReflector ;
	}


	/**
	 * 选用数据库
	 * 
	 * @access	public
	 * @param	$sDBName	string	数据库库名
	 * @return	old_value
	 */
	abstract public function SelectDB(  $sDBName )  ;



	/**
	 * 返回 SelectDB 所设定的数据库
	 * 
	 * @access	public
	 * @return	string,null
	 */
	public function GetCurrentDB()
	{ return $this->sDefaultDatabase ; }



	/**
	 * 返回当前所连接的服务器
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetServer() 
	{ $this->sServer ;}



	/**
	 * 返回当前所有用户
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetUser() 
	{ return $this->sUser ; }
	
	
	/**
	 * 返回错误代码或信息
	 * 
	 * @access	public
	 * @param	$bReturnCode=false	bool 返回代码
	 * @return	string
	 */
	abstract public function GetError($bReturnCode=false) ;


	

	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetLastSQL()
	{
		return $this->sLastSQL ;
	}
	
	
	/**
	 * what's this
	 * 
	 * @access	protected
	 * @param	$SQL		string, JCAT_DBSQL			what's this
	 * @return	void
	 */
	protected function SetLastSQL($SQL)
	{
		$sSQL = JCAT_DBGenericTypes::TransSQL($SQL) ;
		$this->sLastSQL = $sSQL ;
	}
	
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$sDescription=''		string			what's this
	 * @param	$sSQL				string			what's this
	 * @return	void
	 */
	abstract public function ExecuteFail( $sDescription='',$sSQL='' ) ;

	/**
	 * 设置查询耗时
	 *
	 * @access	protected
	 * @param	$nSpecSec		int
	 * @return	void
	 */
	protected function SetQueryTime($nSpecSec)
	{
		$this->nSpecSec = $nSpecSec ;
	}

	/**
	 * 取得查询耗时
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetQueryTime()
	{
		return $this->nSpecSec ;
	}
	
	
	/**
	 * 取得执行SQL所影响的 行数
	 *
	 * @access	public
	 * @return	int
	 */
	abstract public function GetAffectedRows() ;
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 数据库 连接 Handle
	 * 
	 * @access	private
	 * @var		
	 */
	private $hConnectHandle ;

	/**
	 * 缺省数据库 ，通过 SelectDB() 设定
	 * 
	 * @access	private
	 * @var		string
	 */
	protected $sDefaultDatabase = '' ;

	/**
	 * 数据库服务器
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sServer ;

	/**
	 * 用户名
	 * 
	 * @access	private
	 * @var		用户名
	 */
	private $sUser ;

	
	/**
	 * 最近执行的SQL
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sLastSQL = '' ;
	
	/**
	 * 查询费时
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nSpecSec = 0 ;

	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_IDBReflector
	 */
	private $aDBReflector ;
}
?>