<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBConnectMySQL.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * MySQL 连接类
 *
 * @author		alee
 * @access		public
 * @last		2007.12.6
 */
abstract class JCAT_DBConnectMySQL extends JCAT_DBConnect
{
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_DBConnectMySQL()
	{
		$this->SetDBReflector( new JCAT_DBReflectorMySQL($this) ) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsConnected()
	{
		return $this->GetConnectHandle()? true: false ;
	}
	
	/**
	 * 连接数据库服务器
	 * 
	 * @access	public
	 * @param	$sHost='localhost'	string	数据库主机名
	 * @param	$sUser=null			string	用户名，缺省使用当前用户（Linux）
	 * @param	$sPassword=''		string	密码
	 * @param	$bPersistent=true	bool	持久连接
	 * @return	bool
	 */
	public function Connect(  $sHost='localhost',  $sUser='',  $sPassword='',  $bPersistent=true )
	{
		if( $bPersistent )
		{
			$hConn = mysql_pconnect($sHost,$sUser,$sPassword) ;
		}
		else
		{
			$hConn = mysql_connect($sHost,$sUser,$sPassword) ;
		}
		
		if( $hConn )
		{
			$this->SetConnectHandle($hConn) ;
		}

		return $hConn? true: false ;
	}


	/**
	 * 断开连接
	 * 
	 * @access	public
	 * @return	
	 */
	public function Disconnect() 
	{
		if( $bConn = $this->GetConnectHandle() )
			return mysql_close($bConn) ;
		return true ;
	}



	/**
	 * 选用数据库
	 * 
	 * @access	public
	 * @param	$sDBName	string	数据库库名
	 * @return	old_value,false
	 */
	public function SelectDB( $sDBName )
	{
		JCAT_ASSERT::ASSERT_ISTHESE( $hConn=$this->GetConnectHandle(), array('handle'), JCAT_Language::SentenceEx('尚未连接到数据库。','JCAT',null) ) ;
		
		if( !mysql_select_db($sDBName,$hConn) )
		{
			return false ;
		}
		
		$old_value = $this->sDefaultDatabase ;
		$this->sDefaultDatabase = $sDBName ;
		return $old_value ;
	}



	/**
	 * 执行一段SQL语句
	 * 
	 * @access	public
	 * @param	$SQL		JCAT_DBGenericTypes::$SQL	SQL语句
	 * @param	$sDB=null	string						指定数据库。如果为空'' ，则使用当前数据库( SelectDB() )
	 * @return	handle,false
	 */
	public function Query( $SQL, $sDB='', $bSaveSQL=true )
	{
		$sSQL = JCAT_DBGenericTypes::TransSQL($SQL) ;

		// 切换到 指定 数据库
		$sOldDB = '' ;
		if( $sDB and $sDB!=$this->GetCurrentDB() )
		{
			$sOldDB = $this->SelectDB($sDB) ;
		}
		
		// 执行
		$nStartTime = microtime(true) ;
		$Res = mysql_query( $sSQL, $this->GetConnectHandle() ) ;
		$nSpecTime = microtime(true) - $nStartTime ;
		
		// 记录SQL
		if($bSaveSQL)
		{
			$this->SetLastSQL($sSQL) ;
			$this->SetQueryTime($nSpecTime) ;
		}

		// 还原到以前的数据库
		if($sOldDB)
		{
			$this->SelectDB($sOldDB) ;
		}

		// 错误处理
		if($Res===false)
		{
			$this->ExecuteFail(JCAT_Language::SentenceEx('一条 SQL 语句在执行中出错。','JCAT',null),$sSQL) ;
		}
		
		// 返回执行结果
		return $Res ;
	}

	/**
	 * get count of select result
	 * 
	 * @access	public
	 * @param	$aSQL			JCAT_DBSQLSelect	SQL语句
	 * @param	$sDB=null	string				指定数据库 库名
	 * @return	int, false
	 */
	public function GetSelectCount( JCAT_DBSQLSelect $aSQL, $sDB='' )
	{
		$aCountSQL = clone $aSQL ;
		
		$aDBFactory = $aSQL->GetFactory() ;
		$aReturnColumnList = $aCountSQL->GetSubSQLReturnColumnList() ;
		$aReturnColumnList->ClearReturnColumn() ;
		$aReturnColumnList->AddReturnColumn($aDBFactory->CreateFunctionCall('COUNT',array('*'),'Count')) ;
	
		$bResult = $this->Query($aCountSQL,$sDB) ;
		if($bResult===false)
		{
			return false ;
		}
		
		$arrRow = mysql_fetch_assoc($bResult) ;
		return isset($arrRow['Count'])? $arrRow['Count']: false ;
	}

	/**
	 * 返回刚刚插入的行的主键值
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetInsertID()
	{
		return mysql_insert_id() ;
	}
	
	
	
	/**
	 * 开始事务
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function StartTransaction()
	{}



	/**
	 * 提交事务中的操作
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Commit()
	{}



	/**
	 * 放弃事务中的操作
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Rollback()
	{}

	

	/**
	 * 返回错误代码或信息
	 * 
	 * @access	public
	 * @param	$bReturnCode=false	bool 返回代码
	 * @return	string
	 */
	public function GetError($bReturnCode=false)
	{
		if($bReturnCode)
		{
			return mysql_errno() ;
		}
		else
		{
			return mysql_error() ;
		}
	}
	

	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$sDescription=''		string			what's this
	 * @param	$sSQL				string			what's this
	 * @return	void
	 */
	public function ExecuteFail( $sDescription='',$sSQL='' )
	{
		throw new JCAT_DBMySQLException( $sDescription, __macro_exception_code__, $sSQL, $this->GetError(true), $this->GetError() ) ;
	}
	
	/**
	 * 取得执行SQL所影响的 行数
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetAffectedRows()
	{
		return mysql_affected_rows($this->GetConnectHandle()) ;
	}

	// 属性 ///////////////////////////////////////////////////////////////////////////////


}
?>