<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBConnectMySQL41.php 1934 2009-07-10 15:29:10Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/





/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 * @last		2007.12.6
 */
class JCAT_DBConnectMySQL41 extends JCAT_DBConnectMySQL
{


	/**
	 * 连接数据库服务器
	 * 
	 * @access	public
	 * @param	$sHost='localhost'	string	数据库主机名
	 * @param	$sUser=null			string	用户名，缺省使用当前用户（Linux）
	 * @param	$sPassword=''		string	密码
	 * @param	$bPersistent=true	bool	持久连接
	 * @param	$sCharset			string	连接字符集（这是一个隐藏参数，只有 MySQL4.1 可用）
	 * @return	bool
	 */
	public function Connect(  $sHost='localhost',  $sUser='',  $sPassword='',  $bPersistent=true, $sCharset='UTF8' )
	{
		if( !parent::Connect($sHost,$sUser,$sPassword,$bPersistent,$sCharset) )
		{
			return false ;
		}

		return $this->SetCharset($sCharset) ;
	}



	/**
	 * 设定连接字符集
	 * 
	 * @access	public
	 * @param	$sCharset	string	字符集
	 * @return	bool
	 */
	public function SetCharset(  $sCharset ) 
	{
		return mysql_set_charset($sCharset,$this->GetConnectHandle()) ;
	}
	


	
	/**
	 * 开始事务
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function StartTransaction()
	{
		return $this->Query( "START TRANSACTION ;" ) ;
	}


	/**
	 * 提交事务中的操作
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Commit()
	{
		return $this->Query( "COMMIT ;", '', false ) ;
	}



	/**
	 * 放弃事务中的操作
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Rollback()
	{
		return $this->Query( "ROLLBACK ;", '', false ) ;
	}
	


	// 属性 ///////////////////////////////////////////////////////////////////////////////
}
?>