<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBFactoryMySQL.php 1956 2009-08-03 09:24:46Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * MySQL 所有版本的抽象工厂（由于MySQL不同版本之间存在细小差异，这个类仍然是抽象工厂，具体工厂为 具体MySQL版本对应的工厂类）
 *
 * @author		alee
 * @access		public
 */
class JCAT_DBFactoryMySQL extends JCAT_DBAbstractFactory implements JCAT_ISingleton
{
	/**
	 * 返回一个数据库连接对象
	 * 
	 * @access	public
	 * @return	JCAT_DBConnectMySQL40
	 */
	public function CreateConnect() 
	{
		return new JCAT_DBConnectMySQL40() ;
	}
	
	/**
	 * 创建一个 数据表对象
	 * 
	 * @access	public
	 * @param	$sTableName		string	表名
	 * @param	$sAlias=''		string	别名
	 * @return	JCAT_DBTableMySQL
	 */
	public function CreateTable($sTableName,$sAlias='')
	{
		return JCAT_Flyweight::GetGlobalInstance('JCAT_DBTableMySQL',$this,$sTableName,$sAlias) ;
	}



	/**
	 * 创建一个 字段对象
	 * 
	 * @access	public
	 * @param	$sClm		string	字段名称
	 * @param	$sTable=''	string	表名
	 * @return	JCAT_DBColumnMySQL
	 */
	public function CreateColumn( $sClm, $sTable='' )
	{
		return JCAT_Flyweight::GetGlobalInstance('JCAT_DBColumnMySQL',$this,$sClm,$sTable) ;
	}


	/**
	 * 创建一个 字段对象
	 * 
	 * @access	public
	 * @param	$sClm		string					字段名称
	 * @param	$Table=''	string,JCAT_DBTable		表名
	 * @param	$sAlias=''	string					别名
	 * @return	JCAT_DBReturnColumnMySQL
	 */
	public function CreateReturnColumn( $sClm, $Table='', $sAlias='')
	{
		return new JCAT_DBReturnColumnMySQL($this,$sClm,$Table,$sAlias) ;
	}


	/**
	 * 创建一个 字段信息对象
	 * 
	 * @access	public
	 * @param	$aColumn	JCAT_DBColumn	字段对象
	 * @return	JCAT_DBColumnInfoMySQL
	 */
	public function CreateColumnInfo(JCAT_DBColumn $aColumn)
	{
		return new JCAT_DBColumnInfoMySQL($aColumn) ;
	}






	/**
	 * 创建一个 Union SQL对象
	 * 
	 * @access	public
	 * @return	JCAT_DBSQLUnion
	 */
	public function CreateUnion()
	{
		JCAT_ASSERT::ASSERT_(false,JCAT_Language::SentenceEx('留待实现','JCAT',null)) ;
	}


	/**
	 * 创建一个数据库 记录集
	 * 
	 * @access	public
	 * @param	$aConn		JCAT_DBConnect	数据库连接
	 * @return	JCAT_DBRecordSet
	 */
	public function CreateRecordSet( JCAT_DBConnect $aConn )
	{
		return new JCAT_DBRecordSetMySQL($aConn,$this) ;
	}


	/**
	 * 创建一个 JCAT_DBException 对象
	 * 
	 * @access	public
	 * @param	$sMsg=''		string	异常消息
	 * @param	$nCode			int		JCAT统一异常ID，是一个2进制24位整数，左八位代表包ID，左16位代表Class ID，右8位代表异常ID
	 * @param	$sDBSQL=''		string	正在执行的 SQL 语句
	 * @param	$nDBCode=0	int		数据库返回的 错误 Code
	 * @param	$sDBMsg=''		string	数据库返回的 错误讯息
	 * @return	JCAT_DBException
	 */
	public function CreateException( $sMsg='', $nCode=0, $sDBSQL='', $nDBCode=0, $sDBMsg='' )
	{
		return new JCAT_DBMySQLException($sMsg, $nCode, $sDBSQL, $nDBCode, $sDBMsg) ;
	}


	/**
	 * 创建一个 JCAT_DBException 对象
	 * 
	 * @access	public
	 * @return	JCAT_IDBTransaction
	 */
	public function CreateTransaction()
	{
		return new JCAT_DBTransactionMySQL41() ;
	}

	
	/**
	 * create a create sql object
	 *
	 * @access	public
	 * @param	$sTableName		string
	 * @return	JCAT_DBSQLCreate
	 */
	public function CreateSQLCreate($sTableName)
	{
		return new JCAT_DBSQLCreateMySQL($this,$sTableName) ;
	}
	
}
?>