<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: interface.JCAT_IDBAbstractFactory.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 数据库 抽象工厂接口
 *
 * @author		alee
 * @access		public
 */
interface JCAT_IDBAbstractFactory
{


	/**
	 * 创建数据库连接对象
	 * 
	 * @access	public
	 * @return	JCAT_DBConnect
	 */
	public function CreateConnect() ;

	
	/**
	 * create a create sql object
	 *
	 * @access	public
	 * @param	$sTableName		string
	 * @return	JCAT_DBSQLCreate
	 */
	public function CreateSQLCreate($sTableName) ;


	/**
	 * 创建一个 Insert SQL对象
	 * 
	 * @access	public
	 * @param	$sTable=null		string	用于操作的数据表
	 * @param	$bReplace=false		bool	Repalce 或 Insert 
	 * @return	JCAT_DBSQLInsert
	 */
	public function CreateSQLInsert($sTable=null,  $bReplace=false) ;


	/**
	 * 创建一个 Update SQL对象
	 * 
	 * @access	public
	 * @param	$Tables			JCAT_DBGenericTypes::$TableList		数据表
	 * @return	JCAT_DBSQLUpdate
	 */
	public function CreateSQLUpdate($Tables=array()) ;



	/**
	 * 创建一个 Delete SQL对象
	 * 
	 * @access	public
	 * @param	$Tables			JCAT_DBGenericTypes::$TableList		数据表
	 * @return	JCAT_DBSQLDelete
	 */
	public function CreateSQLDelete($Tables=array()) ;



	/**
	 * 创建一个 Select SQL对象
	 * 
	 * @access	public
	 * @param	$Tables			JCAT_DBGenericTypes::$TableList		数据表
	 * @return	JCAT_DBSQLSelect
	 */
	public function CreateSQLSelect($Tables=array()) ;



	/**
	 * 创建一个 数据表对象
	 * 
	 * @access	public
	 * @param	$sTableName		string	表名
	 * @param	$sAlias=''		string	别名
	 * @return	JCAT_DBTableMySQL
	 */
	public function CreateTable($sTableName,$sAlias='') ;

	/**
	 * 创建一个 数据表对象
	 * 
	 * @access	public
	 * @param	$sTableName		string				表名
	 * @param	$aSelect			JCAT_DBSQLSelect	Select 对象
	 * @return	JCAT_DBTableMySQL
	 */
	public function CreateTableSelectResult($sTableName,JCAT_DBSQLSelect $aSelect) ;


	/**
	 * 创建一个 字段对象
	 * 
	 * @access	public
	 * @param	$sClm		string	字段名称
	 * @param	$sTable=''	string	表名
	 * @return	JCAT_DBColumnMySQL
	 */
	public function CreateColumn( $sClm, $sTable='' ) ;


	/**
	 * 创建一个 字段对象
	 * 
	 * @access	public
	 * @param	$sClm		string					字段名称
	 * @param	$sAlias=''	string					别名
	 * @return	JCAT_DBReturnColumnMySQL
	 */
	public function CreateReturnColumn( $sClm, $sAlias='' ) ;



	/**
	 * 创建一个 字段信息对象
	 * 
	 * @access	public
	 * @param	$aColumn	JCAT_DBColumn	字段对象
	 * @return	JCAT_DBColumnInfoMySQL
	 */
	public function CreateColumnInfo(JCAT_DBColumn $aColumn) ;



	/**
	 * 创建一个 数据库函数调用对象
	 * 
	 * @access	public
	 * @param	$sFunc		string											函数名
	 * @param	$Params		base,JCAT_DBColumn,JCAT_DBFunctionCall,array	参数
	 * @param	$sAlias		string											别名
	 * @return	JCAT_DBFunctionCallMySQL
	 */
	public function CreateFunctionCall( $sFunc, $Params=array(), $sAlias='' ) ;



	/**
	 * 创建一个 数据表连接对象
	 * 
	 * @access	public
	 * @param	$LftTables								string,JCAT_DBTable,array	左联表
	 * @param	$RgtTables								string,JCAT_DBTable,array	右联表
	 * @param	$nJoinType=self::TYPE_INNER		int								连接方式
	 * @return	JCAT_DBTableJoin
	 */
	public function CreateTableJoin($LftTables,  $RgtTables=array(),  $nJoinType=null) ;



	/**
	 * 创建一个 Union SQL对象
	 * 
	 * @access	public
	 * @return	JCAT_DBSQLUnion
	 */
	public function CreateUnion() ;



	/**
	 * 创建一个数据库 记录集
	 * 
	 * @access	public
	 * @param	$aConn		JCAT_DBConnect	数据库连接
	 * @return	JCAT_DBRecordSet
	 */
	public function CreateRecordSet( JCAT_DBConnect $aConn ) ;


	/**
	 * 创建一个 ReturnColumnList SQL子句
	 * 
	 * @access	public
	 * @return	JCAT_DBSubSQLReturnColumnList
	 */
	public function CreateSubSQLReturnColumnList() ;

	/**
	 * 创建一个 From SQL子句
	 * 
	 * @access	public
	 * @return	JCAT_DBSubSQLFrom
	 */
	public function CreateSubSQLFrom() ;

	/**
	 * 创建一个 Where SQL子句
	 * 
	 * @access	public
	 * @return	JCAT_DBSubSQLWhere
	 */
	public function CreateSubSQLWhere() ;

	/**
	 * 创建一个 On SQL子句
	 * 
	 * @access	public
	 * @return	JCAT_DBSubSQLOn
	 */
	public function CreateSubSQLOn() ;

	/**
	 * 创建一个 Group SQL子句
	 * 
	 * @access	public
	 * @return	JCAT_DBSubSQLGroup
	 */
	public function CreateSubSQLGroup() ;

	/**
	 * 创建一个 Order SQL子句
	 * 
	 * @access	public
	 * @return	JCAT_DBSubSQLOrder
	 */
	public function CreateSubSQLOrder() ;

	/**
	 * 创建一个 Limit SQL子句
	 * 
	 * @access	public
	 * @return	JCAT_DBSubSQLLimit
	 */
	public function CreateSubSQLLimit() ;

	/**
	 * 创建一个 Condition SQL子句
	 * 
	 * @access	public
	 * @param	$aParent			JCAT_DBSubSQLConditionGroup,null			条件组子句
	 * @param	$Lft				JCAT_DBGenericTypes::$ConditionObject		操作符 左边 的对象
	 * @param	$Rgt				JCAT_DBGenericTypes::$ConditionObject		操作符 右边 的对象
	 * @param	$sOperator='='		string										操作符号
	 * @param	$RightB=null			JCAT_DBGenericTypes::$ConditionObject		用于三目运算的 右边第二个参数
	 * @return	JCAT_DBSubSQLCondition
	 */
	public function CreateSubSQLCondition( $aParent,  $Lft,  $Rgt,  $sOperator='=', $RightB=null ) ;

	/**
	 * 创建一个 ConditionGroup SQL子句
	 * 
	 * @access	public
	 * @param	$bLogic=true	bool						条件组内 各条件的 逻辑关系
	 * @param	$aParent=null	JCAT_DBSubSQLConditionGroup	所属条件组
	 * @param	$sComment=''	string						注释
	 * @return	JCAT_DBSubSQLConditionGroup
	 */
	public function CreateSubSQLConditionGroup($bLogic=true, JCAT_DBSubSQLConditionGroup $aParent=null,  $sComment='') ;

	/**
	 * 创建一个 JCAT_DBExpression 对象
	 * 
	 * @access	public
	 * @param	$sExpression		string		表达式
	 * @return	JCAT_DBExpression
	 */
	public function CreateExpression($sExpression) ;


	/**
	 * 创建一个 JCAT_DBException 对象
	 * 
	 * @access	public
	 * @param	$sMsg=''		string	异常消息
	 * @param	$nCode			int		JCAT统一异常ID，是一个2进制24位整数，左八位代表包ID，左16位代表Class ID，右8位代表异常ID
	 * @param	$sDBSQL=''		string	正在执行的 SQL 语句
	 * @param	$nDBCode=0	int		数据库返回的 错误 Code
	 * @param	$sDBMsg=''		string	数据库返回的 错误讯息
	 * @return	JCAT_DBException
	 */
	public function CreateException( $sMsg='', $nCode=0, $sDBSQL='', $nDBCode=0, $sDBMsg='' ) ;


	/**
	 * 创建一个 JCAT_DBException 对象
	 * 
	 * @access	public
	 * @return	JCAT_IDBTransaction
	 */
	public function CreateTransaction() ;
}
?>