<?php
// Call JCAT_DBFunctionCallTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_DBFunctionCallTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/桌面/lib.php/Common/DB/DBObject/class.JCAT_DBFunctionCall.php';

/**
 * Test class for JCAT_DBFunctionCall.
 * Generated by PHPUnit on 2007-12-25 at 13:48:03.
 */
class JCAT_DBFunctionCallTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_DBFunctionCallTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testMakeSQL().
     */
    public function testMakeSQL() {
	
				$aFactory = JCAT_Singleton::GetGlobalInstance('JCAT_DBFactoryMySQL41') ;
		
		$aFunctionCall = $aFactory->CreateFunctionCall('aa') ;
		$this->assertEquals( $aFunctionCall->MakeSQL(), 'aa(  )' ) ;
		
		$aFunctionCall = $aFactory->CreateFunctionCall('aa',array(1,2,'aa',true)) ;
		$this->assertEquals( $aFunctionCall->MakeSQL(), "aa( 1, 2, 'aa', '1' )" ) ;
		
		$aFunctionCall2 = $aFactory->CreateFunctionCall('bb',array(1,2,'aa',$aFunctionCall)) ;
		$this->assertEquals( $aFunctionCall2->MakeSQL(), "bb( 1, 2, 'aa', aa( 1, 2, 'aa', '1' ) )" ) ;
		
		
		$aClm = $aFactory->CreateColumn('aa','cc') ;
		$aFunctionCall2 = $aFactory->CreateFunctionCall('bb',array($aClm,2,'aa',$aFunctionCall)) ;
		$this->assertEquals( $aFunctionCall2->MakeSQL(), "bb( `cc`.`aa`, 2, 'aa', aa( 1, 2, 'aa', '1' ) )" ) ;
		
		
		$aFunctionCall2 = $aFactory->CreateFunctionCall('bb',array($aClm,2,'aa',$aFunctionCall),'hi') ;
		$this->assertEquals( $aFunctionCall2->MakeSQL(), "bb( `cc`.`aa`, 2, 'aa', aa( 1, 2, 'aa', '1' ) ) as hi" ) ;
    }
}

// Call JCAT_DBFunctionCallTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_DBFunctionCallTest::main')
	JCAT_DBFunctionCallTest::main();
?>
