<?php
// Call JCAT_DBReturnColumnMySQLTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_DBReturnColumnMySQLTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/桌面/lib.php/Common/DB/DBObject/class.JCAT_DBReturnColumnMySQL.php';

/**
 * Test class for JCAT_DBReturnColumnMySQL.
 * Generated by PHPUnit on 2007-12-24 at 20:20:08.
 */
class JCAT_DBReturnColumnMySQLTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_DBReturnColumnMySQLTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testMakeSQL().
     */
    public function testMakeSQL() {
	
				$aFactory = JCAT_Singleton::GetGlobalInstance('JCAT_DBFactoryMySQL41') ;
				
		$aRetClm = $aFactory->CreateReturnColumn('aaa') ;
		$this->assertEquals($aRetClm->MakeSQL(),'`aaa`') ;
		
		$aRetClm = $aFactory->CreateReturnColumn('aaa.bbb') ;
		$this->assertEquals($aRetClm->MakeSQL(),'`aaa`.`bbb`') ;
		
		$aRetClm = $aFactory->CreateReturnColumn('aaa.bbb','ccc') ;
		$this->assertEquals($aRetClm->MakeSQL(),'`aaa`.`bbb` as `ccc`') ;
		
		
		$aColumnB = $aFactory->CreateColumn('bbb') ;
		
		$aRetClm = $aFactory->CreateReturnColumn($aColumnB,'ccc') ;
		$this->assertEquals($aRetClm->MakeSQL(),'`bbb` as `ccc`') ;		
		
		
		$aColumnC = $aFactory->CreateColumn('bbb','aaa') ;
		
		$aRetClm = $aFactory->CreateReturnColumn($aColumnC) ;
		$this->assertEquals($aRetClm->MakeSQL(),'`aaa`.`bbb`') ;
		
		$aRetClm = $aFactory->CreateReturnColumn($aColumnC,'ccc') ;
		$this->assertEquals($aRetClm->MakeSQL(),'`aaa`.`bbb` as `ccc`') ;
    }
}

// Call JCAT_DBReturnColumnMySQLTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_DBReturnColumnMySQLTest::main')
	JCAT_DBReturnColumnMySQLTest::main();
?>
