<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBColumn.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 数据 字段
 *
 * @author		alee
 * @access		public
 */
class JCAT_DBColumn extends JCAT_DBStructObject implements JCAT_IFlyweight
{


	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$aFactory=null	JCAT_DBAbstractFactory	对象工厂
	 * @param	$sClm			string					字段名称
	 * @param	$sTable=''		string					表名
	 * @return	void
	 */
	public function JCAT_DBColumn( JCAT_DBAbstractFactory $aFactory=null, $sClm, $sTable='' ) 
	{
		JCAT_ASSERT::ASSERT_STRING($sTable) ;
		
		// 'table.column' 格式
		$arr = explode('.',$sClm) ;
		if( count($arr)>1 )
		{
			$this->aTable = $aFactory->CreateTable($arr[0]) ;
			$sColumnName = $arr[1] ;
		}
		else
		{
			$this->aTable = $sTable? $aFactory->CreateTable($sTable): null ;
			$sColumnName = $sClm ;
		}
		
		$this->JCAT_DBStructObject($sColumnName) ;
		if($aFactory)
		{
			$this->SetFactory($aFactory) ;
		}
	}

	
	/**
	 * 创建并返回SQL语句
	 * 并不是所有数据库都使用 反引号“`”，MakeSQL() 由 数据库 各自的字段类实现
	 * 
	 * @access	public
	 * @return	string
	 */
	public function MakeSQL()
	{
		$sTableName = $this->GetTableName() ;
		if($sTableName)	
			$sTableName = "{$sTableName}." ;
			
		return $sTableName.$this->GetName() ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sTextName		What's this Parameter ?
	 * @return	
	 */
	public function IsSameColumn(  $sTextName ) 
	{
		// Todo Samething ... ...
		// ... ...
	}



	/**
	 * 返回表名
	 * 
	 * @access	public
	 * @return	
	 */
	public function GetTableName(  ) 
	{ return $this->aTable? $this->aTable->GetName(): '' ; }



	/**
	 * 返回 数据表对象
	 * 
	 * @access	public
	 * @return	JCAT_DBTable
	 */
	public function GetTable() 
	{ return $this->aTable ; }



	/**
	 * 根据数据库类型 返回一个 字段信息 对象
	 * 
	 * @access	public
	 * @param	$aConnect	JCAT_DBConnect	What's this Parameter ?
	 * @return	JCAT_DBColumnInfo
	 */
	public function QueryInfo( JCAT_DBConnect $aConnect ) 
	{
		JCAT_ASSERT::ASSERT_INSTANCE( $aFactory=$this->GetFactory(), 'JCAT_DBAbstractFactory' ) ;
		
		$aClmInfo = $aFactory->CreateColumnInfo($this) ;
		$aClmInfo->QueryInfo($aConnect) ;
		
		return $aConnect ;
	}


	/**
	 * 返回 享元实例 的 Key
	 * 
	 * @access	public
	 * @param	$aFactory		JCAT_DBAbstractFactory	对象工厂
	 * @param	$sColumnName	string					字段名
	 * @param	$sTableName		string					表名
	 * @static
	 * @return	string
	 */
	static public function GetFlyweightKey()
	{
		$arrArgs = func_get_args () ;
		if( !isset($arrArgs[2]) )
			$arrArgs[2] = '' ;
		JCAT_ASSERT::ASSERT_( count($arrArgs)==3, '此方法的参数表为：$aFactory:JCAT_DBAbstractFactory, $sColumnName:string, $sTableName:string' ) ;
		return $arrArgs[2].'.'.$arrArgs[1] ;
	}


	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 数据表 表名
	 * 
	 * @access	private
	 * @var		string
	 */
	private $aTable = '' ;


}

JCAT_Flyweight::RegisterInstanceFactory( 'JCAT_DBColumn' ) ;

?>