<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBFunctionCall.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/



/**
 * 数据库函数 调用
 *
 * @author		alee
 * @access		public
 */
class JCAT_DBFunctionCall extends JCAT_DBObject
{


	/**
	 * 
	 * @access	public
	 * @param	$aFactory	JCAT_DBAbstractFactory							对象工厂
	 * @param	$sFunc		string											函数名
	 * @param	$Params		base,JCAT_DBColumn,JCAT_DBFunctionCall,array	参数
	 * @param	$sAlias		string											别名
	 * @return	
	 */
	public function JCAT_DBFunctionCall( JCAT_DBAbstractFactory $aFactory, $sFunc, $Params=array(), $sAlias='' ) 
	{
		JCAT_ASSERT::ASSERT_STRING( $sFunc ) ;
		
		if( !is_array($Params) )
		{
			$arrParams = (array)$Params ;
		}
		else
		{
			$arrParams = $Params ;		
		}
		JCAT_ASSERT::ASSERT_ISTHESE( $arrParams, array('array:base,JCAT_DBColumn,JCAT_DBFunctionCall') ) ;
		
		$this->arrParams = $arrParams ;
		$this->sFuncName = $sFunc ;
		$this->sAlias = $sAlias ;
		
		$this->JCAT_DBObject($aFactory) ;
	}

	/**
	 * 创建并返回SQL语句
	 * 
	 * @access	public
	 * @return	string
	 */
	public function MakeSQL()
	{
		// SQL 子句
		$arrSQL = array() ;
		foreach($this->arrParams as $Param)
		{
			if( is_object($Param) )
			{
				$arrSQL[] = $Param->MakeSQL() ;
			}
			else
			{
				$arrSQL[] = JCAT_DBGenericTypes::TransValue($Param) ;
			}
		}
		 $sSQL= implode(', ',$arrSQL) ;
		
		return "{$this->sFuncName}( {$sSQL} )" . ($this->sAlias? " as '{$this->sAlias}'": '') ;
	}

	/**
	 * 返回别名
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetAlias(  ) 
	{ return $this->sAlias; }



	/**
	 * 设置别名
	 * 
	 * @access	public
	 * @param	$sAlias		string	别名
	 * @return	old_value
	 */
	public function SetAlias( $sAlias ) 
	{
		JCAT_ASSERT::ASSERT_STRING($sAlias) ;
		
		$old_value = $this->sAlias ;
		$this->sAlias = $sAlias ;
		return $old_value ;
	}


	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 参数
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrParams =array() ;


	/**
	 * 函数名
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sFuncName ;


	/**
	 * 别名
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sAlias ;
}
?>