<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBStructObject.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 数据库结构对象（数据表、数据字段 对象的父类）
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_DBStructObject extends JCAT_DBObject
{

	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$sClm		string	名称
	 * @param	$sAlias=''	string	别名
	 * @return	void
	 */
	function JCAT_DBStructObject($sName,$sAlias='')
	{
		JCAT_ASSERT::ASSERT_STRING($sName) ;
		JCAT_ASSERT::ASSERT_STRING($sAlias) ;

		$this->sName = $sName ;
		$this->sAlias = $sAlias ;
	}

	/**
	 * 返回名称
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetName(  ) 
	{ return $this->sName ; }



	/**
	 * 返回别名
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetAlias(  ) 
	{ return $this->sAlias; }



	/**
	 * 设置别名
	 * 
	 * @access	public
	 * @param	$sAlias		string	别名
	 * @return	old_value
	 */
	public function SetAlias( $sAlias ) 
	{
		JCAT_ASSERT::ASSERT_STRING($sAlias) ;
		
		$old_value = $this->sAlias ;
		$this->sAlias = $sAlias ;
		return $old_value ;
	}
	




	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 名称
	 * 
	 * @access	private
	 * @var		string		
	 */
	private $sName = '' ;

	/**
	 * 别名
	 * 
	 * @access	private
	 * @var		string		
	 */
	private $sAlias = '' ;
	


}
?>