<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBTableJoin.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 数据表连接对象
 *
 * @author		alee
 * @access		public
 */
class JCAT_DBTableJoin extends JCAT_DBObject
{
	/**
	 * 
	 * @access	public
	 * @param	$aFactory						JCAT_DBAbstractFactory		一个具体工厂
	 * @param	$LftTables						string,JCAT_DBTable,array	左联表
	 * @param	$RgtTables						string,JCAT_DBTable,array	右联表
	 * @param	$nJoinType=self::TYPE_INNER		int							连接方式
	 * @return	void
	 */
	public function JCAT_DBTableJoin( JCAT_DBAbstractFactory $aFactory, $LftTables,  $RgtTables=array(),  $nJoinType=self::TYPE_INNER ) 
	{
		// 父类的构造函数
		$this->JCAT_DBObject($aFactory) ;
		
		JCAT_ASSERT::ASSERT_ISTHESE($LftTables,array('string','JCAT_DBTable','array:string,JCAT_DBTable')) ;
		JCAT_ASSERT::ASSERT_ISTHESE($RgtTables,array('string','JCAT_DBTable','array:string,JCAT_DBTable')) ;
		JCAT_ASSERT::ASSERT_INT($nJoinType) ;
		JCAT_ASSERT::ASSERT_( ($nJoinType>=self::TYPE_MIN and $nJoinType<=self::TYPE_MAX),
			JCAT_Language::SentenceEx('参数 $nJoinType 只能是： JCAT_DBTableJoin::TYPE_INNER, JCAT_DBTableJoin::TYPE_LEFT, JCAT_DBTableJoin::TYPE_RIGHT, JCAT_DBTableJoin::TYPE_OUTTER','JCAT',null) ) ;

		$this->aSubSQLOn = $aFactory->CreateSubSQLConditionGroup() ;
		$this->nJoinType = $nJoinType ;
		
		
		// 统一为一个数组
		if( is_string($LftTables) or JCAT_Global::IsKindOf($LftTables,'JCAT_DBTable') )
		{
			$arrLftTables = array( $LftTables ) ;
		}
		else if( is_array($LftTables) )
		{
			$arrLftTables = $LftTables ;
		}
		else
		{
			JCAT_ASSERT::ASSERT_(0,'?!') ;		
		}
			
		if( is_string($RgtTables) or JCAT_Global::IsKindOf($RgtTables,'JCAT_DBTable') )
		{
			$arrRgtTables = array( $RgtTables ) ;
		}
		else if( is_array($RgtTables) )
		{
			$arrRgtTables = $RgtTables ;
		}
		else
		{
			JCAT_ASSERT::ASSERT_(0,'?!') ;		
		}
			
		// 检查是否 空数组
		JCAT_ASSERT::ASSERT_(count($arrLftTables),JCAT_Language::SentenceEx('参数 $LftTables 不能为空。','JCAT',null)) ;

		
		// 加入 ... ...
		foreach($arrLftTables as $Item)
		{
			$this->AddTable($Item,true) ;		
		}
		
		foreach($arrRgtTables as $Item)
		{
			$this->AddTable($Item,false) ;		
		}
	}


	/**
	 * 
	 *
	 * @access	public
	 * @param	$Table		string,JCAT_DBTable		What's this Parameter ?
	 * @param	$bLftTable	bool					What's this Parameter ?
	 * @return	void
	 */
	public function AddTable( $Table, $bLftTable=true )
	{
		JCAT_ASSERT::ASSERT_ISTHESE($Table,array('string','JCAT_DBTable')) ;
		
		$aFactory = $this->GetFactory() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aFactory,'JCAT_DBAbstractFactory') ;
		
		if($bLftTable)
		{
			$arrTables = $this->arrLftTables ;
		}
		else
		{
			$arrTables = $this->arrRgtTables ;
		}

		$aTable = JCAT_DBGenericTypes::TransTable($aFactory,$Table) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aTable,'JCAT_DBTable') ;

		$arrTables[$aTable->GetName()] = $aTable ;
	}
	
	
	/**
	 * 
	 *
	 * @access	public
	 * @param	$bLftTable	bool	What's this Parameter ?
	 * @return	void
	 */
	public function CreateTableIterator( $bLftTable=true )
	{
				
		if($bLftTable)
		{
			return new JCAT_ArrayIterator($this->arrLftTables) ;
		}
		else
		{
			return new JCAT_ArrayIterator($this->arrRgtTables) ;
		}
	}
	
	
	/**
	 * 
	 *
	 * @access	public
	 * @param	$bLftTable	bool	What's this Parameter ?
	 * @return	void
	 */
	public function GetTableCount( $bLftTable=true )
	{		
		if($bLftTable)
		{
			return count($this->arrLftTables) ;
		}
		else
		{
			return count($this->arrRgtTables) ;
		}
	}
	


	/**
	 * 设置用于将两个表关联起来的外键字段
	 * 
	 * @access	public
	 * @param	$KeyA			string,JCAT_DBColumn	外键A
	 * @param	$KeyB			string,JCAT_DBColumn	外键B
	 * @param	$sOperator='='	string					运算符
	 * @param	$KeyC=null		string,JCAT_DBColumn	外键C
	 * @return	
	 */
	public function AddForeignKey( $KeyA, $KeyB, $sOperator='=',$KeyC=null ) 
	{
		JCAT_ASSERT::ASSERT_ISTHESE($KeyA,array('string','JCAT_DBColumn')) ;
		JCAT_ASSERT::ASSERT_ISTHESE($KeyB,array('string','JCAT_DBColumn')) ;
		JCAT_ASSERT::ASSERT_ISTHESE($KeyC,array('null','string','JCAT_DBColumn')) ;
		
		$aFactory = $this->GetFactory() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aFactory,'JCAT_DBAbstractFactory') ;
		
		// 统一类型
		if( is_string($KeyA) )
		{
			$aKeyColumnA = $aFactory->CreateColumn($KeyA) ;
		}
		elseif( JCAT_Global::IsKindOf($KeyA,'JCAT_DBColumn') )
		{
			$aKeyColumnA = $KeyA ;
		}
		else
		{
			JCAT_ASSERT::ASSERT_(0,'?!') ;
		}
			
		if( is_string($KeyB) )
		{
			$aKeyColumnB = $aFactory->CreateColumn($KeyB) ;
		}
		elseif( JCAT_Global::IsKindOf($KeyB,'JCAT_DBColumn') )
		{
			$aKeyColumnB = $KeyB ;
		}
		else
		{
			JCAT_ASSERT::ASSERT_(0,'?!') ;
		}
			
		if( is_string($KeyC) )
		{
			$aKeyColumnC = $aFactory->CreateColumn($KeyC) ;
		}
		elseif( JCAT_Global::IsKindOf($KeyC,'JCAT_DBColumn') )
		{
			$aKeyColumnC = $KeyC ;
		}
		else
		{
			$aKeyColumnC = null ;
		}
		
		// 检查 表名 （数据表实行享元模式，同名数据表 均为同一个对象）
		$arrTotalTables = array_merge($this->arrRgtTables,$this->arrLftTables) ;
		JCAT_ASSERT::ASSERT_( in_array($aKeyColumnA->GetTable(),$arrTotalTables),JCAT_Language::SentenceEx('参数 $KeyA 必须指定表名，且指定的表名为用于Join操作的表','JCAT',null)) ;
		JCAT_ASSERT::ASSERT_( in_array($aKeyColumnB->GetTable(),$arrTotalTables),JCAT_Language::SentenceEx('参数 $KeyB 必须指定表名，且指定的表名为用于Join操作的表','JCAT',null)) ;
		if($aKeyColumnC)
		{
			JCAT_ASSERT::ASSERT_( in_array($aKeyColumnC->GetTable(),$arrTotalTables),JCAT_Language::SentenceEx('参数 $KeyC 必须指定表名，且指定的表名为用于Join操作的表','JCAT',null)) ;
		}
		
		// 加入
		$aCondition = $aFactory->CreateSubSQLCondition($this->aSubSQLOn,$aKeyColumnA,$aKeyColumnB,$sOperator,$aKeyColumnC) ;
		$this->aSubSQLOn->AddCondition( $aCondition ) ;
	}



	/**
	 * 设置两个表中同名的外键字段
	 * 
	 * @access	public
	 * @param	$sKeyName	string	同名的字段名（不要带入表名）
	 * @return	void
	 */
	public function AddSameNameForeignKey( $sKeyName ) 
	{
		JCAT_ASSERT::ASSERT_STRING($sKeyName) ;
		
		$aFactory = $this->GetFactory() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aFactory,'JCAT_DBAbstractFactory') ;
		
		$aColumn = $aFactory->CreateColumn($sKeyName) ;
		JCAT_ASSERT::ASSERT_($aColumn->GetTableName()=='',JCAT_Language::SentenceEx('参数 $sKeyName 不应带入表名','JCAT',null)) ;
		
		$this->arrUsingColumns[] = $aColumn ;
	}

	
	/**
	 * 取得 On 子句
	 *
	 * @access	public
	 * @return	JCAT_DBSubSQLConditionGroup
	 */
	public function GetSubSQLOn()
	{
		return $this->aSubSQLOn ;
	}

	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$aConditionOrGroup	JCAT_DBSubSQLCondition		what's this
	 * @return	void
	 */
	public function AddJoinCondition(JCAT_DBSubSQLCondition $aConditionOrGroup)
	{
		$this->aSubSQLOn->AddCondition($aConditionOrGroup) ;
	}


	/**
	 * 创建并返回SQL语句
	 * 
	 * @access	public
	 * @return	string
	 */
	public function MakeSQL()
	{
		JCAT_ASSERT::ASSERT_(count($this->arrLftTables)) ;
		JCAT_ASSERT::ASSERT_ISTHESE($this->arrLftTables,'array:JCAT_DBTable') ;
		JCAT_ASSERT::ASSERT_ISTHESE($this->arrRgtTables,'array:JCAT_DBTable') ;
		
		// 两边的表名
		$sLftTables = $this->_MakeSQLTableList($this->arrLftTables) ;
		$sRgtTables = $this->_MakeSQLTableList($this->arrRgtTables) ;
		
		// 只有单边，无法组成连接，以普通方式 输出
		if( empty($sLftTables) or empty($sRgtTables) )
		{
			return $sLftTables.$sRgtTables ;
		}
		
		// 连接方式
		$sJoinType = self::$arrJoinType[ $this->nJoinType ] ;
		
		// On 子句
		$sSubSQLOn = $this->aSubSQLOn->MakeSQL() ;
		if( $sSubSQLOn )
		{
			if($this->aSubSQLOn->GetConditionCount()==1)
			{
				$sSubSQLOn = "($sSubSQLOn)" ;
			}
			$sSubSQLOn = " On {$sSubSQLOn}" ;
		}
		
		// Using 子句
		$sSubSQLUsing = '' ;
		if( count($this->arrUsingColumns) )
		{
			JCAT_ASSERT::ASSERT_ISTHESE($this->arrUsingColumns,'array:JCAT_DBColumn') ;
			
			$arrSubSQLUsing = array() ;
			foreach($this->arrUsingColumns as $aColumn)
			{
				$arrSubSQLUsing[] = $aColumn->MakeSQL() ;
			}
			$sSubSQLUsing = ' USING ('. implode(', ',$arrSubSQLUsing) .')' ;
		}
		
		return "{$sLftTables} {$sJoinType} {$sRgtTables}{$sSubSQLOn}{$sSubSQLUsing}" ;
	}


	/**
	 * 
	 *
	 * @access	private
	 * @return	string, ''
	 */
	private function _MakeSQLTableList( $arrTables )
	{
		$nTableCount = count($arrTables) ;
		switch ( $nTableCount )
		{
			case 0 :
				return '' ;
				break ;
			
			case 1 :
				$aTable = end($arrTables) ;
				return $aTable->MakeSQL() ;
				break ;
			
			default :
			
				$arrRetTables = array() ;
				foreach($arrTables as $aTable)
				{
					$arrRetTables[] = $aTable->MakeSQL() ;
				}
				
				return '('. implode(', ',$arrRetTables) .')' ;
				break ;
		}

	}
	

	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 边界最小值
	 * 
	 * @access	const
	 * @var		int
	 */
	const TYPE_MIN = 1 ;
	
	/**
	 * 连接方式
	 * 
	 * @access	const
	 * @var		int
	 */
	const TYPE_INNER = 1 ;

	/**
	 * 连接方式
	 * 
	 * @access	const
	 * @var		int
	 */
	const TYPE_LEFT = 2 ;

	/**
	 * 连接方式
	 * 
	 * @access	const
	 * @var		int
	 */
	const TYPE_RIGHT = 3 ;

	/**
	 * 连接方式
	 * 
	 * @access	const
	 * @var		int
	 */
	const TYPE_CROSS = 4 ;

	/**
	 * 边界最大值
	 * 
	 * @access	const
	 * @var		int
	 */
	const TYPE_MAX = 4 ;



	static private $arrJoinType = array(
		1 => 'JOIN' ,
		2 => 'LEFT JOIN' ,
		3 => 'RIGHT JOIN' ,
		4 => 'CROSS JOIN' ,
	) ;
		
	/**
	 * 连接方式
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nJoinType = 0 ;
		
	/**
	 * 连接右端的表
	 * 
	 * @access	private
	 * @var		array:JCAT_DBTable
	 */
	private $arrRgtTables = array() ;

	/**
	 * 连接左端的表
	 * 
	 * @access	private
	 * @var		array:JCAT_DBTable
	 */
	private $arrLftTables = array() ;


	/**
	 * 用于 Using 子句的字段
	 * 
	 * @access	private
	 * @var		array:JCAT_DBColumn
	 */
	private $arrUsingColumns = array() ;

	/**
	 * On 子句的字段
	 * 
	 * @access	private
	 * @var		JCAT_DBSubSQLConditionGroup
	 */
	private $aSubSQLOn ;

}
?>