<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBRecordSet.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 数据库 记录集
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_DBRecordSet
{
	/**
	 * 
	 * @access	public
	 * @param	$aConn	JCAT_DBConnect	数据库连接
	 * @return	void
	 */
	public function JCAT_DBRecordSet( JCAT_DBConnect $aConnect, JCAT_IDBAbstractFactory $aDBFactory ) 
	{
		$this->aConnect = $aConnect ;
		$this->aDBFactory = $aDBFactory ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IDBAbstractFactory
	 */
	public function GetFactory()
	{
		return $this->aDBFactory ;	
	}

	/**
	 * 取回 数据库连接对象
	 * 
	 * @access	public
	 * @return	JCAT_DBConnect
	 */
	public function GetConnect()
	{ return $this->aConnect ; }


	/**
	 * 查询
	 * 
	 * @access	public
	 * @param	$aSQL	JCAT_DBSQLSelect,string		SQL 查询语句
	 * @return	
	 */
	public function Query( $SQL )
	{
		JCAT_ASSERT::ASSERT_ISTHESE($SQL,array('JCAT_DBSQLSelect','string')) ;
		$this->RunSelectSQL = $SQL ;
		
		// 执行查询
		$aConnect = $this->GetConnect() ;
		$Res = $aConnect->Query($SQL) ;
		
		// 重置
		$this->nCount = -1 ;
		$this->nSeek = 0 ;
		$this->arrDatas = array() ;
		
		if( !$Res )
		{
			return false ;
		}
		
		$this->SetQueryResultHandle($Res) ;
		return true ;
	}



	/**
	 * 设置查询结果句柄
	 * 
	 * @access	public
	 * @param	$hRes		handle	查询结果句柄
	 * @return	old_value
	 */
	public function SetQueryResultHandle( $hRes ) 
	{
		$old_value = $this->hResult ;
		$this->hResult = $hRes ;
		return $old_value ;
	}



	/**
	 * 返回查询结果句柄
	 * 
	 * @access	public
	 * @return	handle,null
	 */
	public function GetQueryResultHandle(  ) 
	{ return $this->hResult ; }



	/**
	 * 取回结果行数
	 * 
	 * @access	public
	 * @return	int
	 */
	abstract public function GetCount()  ;



	/**
	 * 返回一行记录
	 * 
	 * @access	public
	 * @return	array,null
	 */
	abstract public function Fetch()  ;



	/**
	 * 设置内部偏移指针
	 * 
	 * @access	public
	 * @parama	$nSeek	int	指针
	 * @return	old_value
	 */
	abstract public function SetSeek(  $nSeek )  ;



	/**
	 * 取回内部偏移指针
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetSeek() 
	{ return $this->nSeek ;}


	/**
	 * 返回指定行的内容
	 * 
	 * @access	public
	 * @param	$nRow=-1			int		行数
	 * @return	array,null
	 */
	public function GetRow( $nRow=-1 ) 
	{
		JCAT_ASSERT::ASSERT_INT($nRow) ;
		$nOldSeek = $this->GetSeek() ;
		
		// 移到指定位置
		if($nRow>-1)
		{
			$this->SetSeek($nRow) ;
		}
				
		// 取回
		$arrRow = $this->Fetch() ;
		
		if($arrRow===null)
		{
			return null ;
		}
		else
		{
			// 退回到 原来位置
			$this->SetSeek($nOldSeek) ;
			return $arrRow ;
		}
	}

	/**
	 * 取得所有 行
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetAllRows()
	{
		$arrRet = array() ;
						
		while( $arrRow = $this->Fetch() )
		{
			$arrRet[] = $arrRow ;
		}
		
		return $arrRet ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sFieldName
	 * @return	string
	 */
	public function GetField($sFieldName)
	{
		$arrRow = $this->GetRow() ;
		if(empty($arrRow))
		{
			return null ;
		}
		
		return array_key_exists($sFieldName,$arrRow)?
					$arrRow[$sFieldName]: null ;
	}
	
	/**
	 * create and return a iterator for all rows
	 * 
	 * @access	public
	 * @return	JCAT_DBRowIterator
	 */
	public function CreateRowIterator() 
	{
		return new JCAT_DBRowIterator($this) ;
	}


	/**
	 * create and return a iterator for all fields of current row
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateFieldIterator()
	{
		$arrRow = $this->GetRow() ;
		return ($arrRow===null)?
				new JCAT_NullIterator():
				new JCAT_ArrayIterator(array_keys($arrRow)) ;
	}


	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 返回记录内部指针
	 * 
	 * @access	protected
	 * @var		int
	 */
	protected $nSeek = -1 ;

	/**
	 * 结果内容
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrDatas = array() ;

	/**
	 * 结果行数
	 * 
	 * @access	private
	 * @var		int
	 */
	protected $nCount = -1 ;

	/**
	 * 数据库连接
	 * 
	 * @access	private
	 * @var		JCAT_DBConnect
	 */
	private $aConnect ;

	/**
	 * Query 传入的SQL
	 * 
	 * @access	private
	 * @var		JCAT_DBSQLSelect,string
	 */
	private $RunSelectSQL = '' ;

	/**
	 * 查询结果句柄
	 * 
	 * @access	private
	 * @var		handle,null
	 */
	private $hResult = null ;


	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_IDBAbstractFactory
	 */
	private $aDBFactory ;
	

}

?>