<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBRecordSetMySQL.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_DBRecordSetMySQL extends JCAT_DBRecordSet
{
	/**
	 * 取回结果行数
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetCount() 
	{
		// 直接返回结果
		if( $this->nCount>=0 )
		{
			return $this->nCount ;
		}
		
		// 
		$hResult = $this->GetQueryResultHandle() ;
		if( !$hResult )
		{
			throw new JCAT_DBMySQLException( JCAT_Language::SentenceEx('尚未执行查询操作。','JCAT',null), JCAT_Exception::MakeExceptionCode(__CLASS__,1) ) ;
		}
		
		$this->nCount = mysql_num_rows($hResult) ;
		return $this->nCount ;
	}


	/**
	 * 返回一行记录
	 * 
	 * @access	public
	 * @return	array,null
	 */
	public function Fetch() 
	{		
		$hResult = $this->GetQueryResultHandle() ;
		if( !$hResult )
		{
			throw new JCAT_DBMySQLException( JCAT_Language::SentenceEx('尚未执行查询操作。','JCAT',null), JCAT_Exception::MakeExceptionCode(__CLASS__,1) ) ;
		}

		$nCount = $this->GetCount() ;
		$nSeek = $this->GetSeek() ;
			
		// 已经操作最后一行
		if( $nSeek>=$nCount )
		{
			return null ;
		}
		
		// 无缓存内容，查询取得
		if( !isset($this->arrDatas[$nSeek]) )
		{
			$this->SetSeek($nSeek) ;
			$arrRow = mysql_fetch_assoc($hResult) ;
			JCAT_ASSERT::ASSERT_($arrRow!==false,'!?') ;
			
			// 缓存内容
			$this->arrDatas[$nSeek] = $arrRow ;
		}

		// 后移并返回
		$this->nSeek++ ;
		return $this->arrDatas[$nSeek] ;
	}



	/**
	 * 设置内部偏移指针
	 * 
	 * @access	public
	 * @parama	$nSeek	int	指针
	 * @return	old_value
	 */
	public function SetSeek($nSeek) 
	{
		$hResult = $this->GetQueryResultHandle() ;
		if( !$hResult )
		{
			throw new JCAT_DBException( JCAT_Language::SentenceEx('尚未执行查询操作。','JCAT',null), JCAT_Exception::MakeExceptionCode(__CLASS__,1) ) ;
		}
		
		// 检查溢出
		$nCount = $this->GetCount() ;
		if( $nSeek<0 or $nSeek>=$nCount )
		{
			JCAT_ASSERT::ASSERT_( 0,JCAT_Language::SentenceEx('设置内部偏移指针值发生溢出：%d，最大的可接受值为：%d','JCAT',null,$nSeek,$nCount)) ;
		}
		
		// 
		if( !mysql_data_seek($hResult,$nSeek) )
		{
			throw new JCAT_DBException( JCAT_Language::SentenceEx('设置查询结果指针失败','JCAT',null), __macro_exception_code__, '', mysql_errno(), mysql_error() ) ;
		}
		
		// 设置并返回
		$old_value = $this->nSeek ;
		$this->nSeek = $nSeek ;
		return $old_value ;
	}




	// 属性 ///////////////////////////////////////////////////////////////////////////////


}
/*macro_exception_code:1*/
?>