<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBRowIterator.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/





/**
 * 数据库记录集  行迭代器
 *
 * @author		alee
 * @access		public
 */
class JCAT_DBRowIterator implements JCAT_IBothwayIterator
{


	/**
	 * 
	 * @access	public
	 * @param	$aRecordSet	JCAT_DBRecordSet	被迭代的记录集
	 * @return	
	 */
	public function JCAT_DBRowIterator( JCAT_DBRecordSet $aRecordSet ) 
	{
		$this->aRecordSet = $aRecordSet ;		
		$this->First() ;
	}



	/**
	 * 回到第一个
	 * 
	 * @access	public
	 * @return	array,null
	 */
	public function First() 
	{
		if( $this->aRecordSet->GetCount()<=0 )
		{
			return null ;
		}
		return $this->aRecordSet->GetRow($this->nIdx=0,true) ;
	}



	/**
	 * 返回当前内容
	 * 
	 * @access	public
	 * @return	array,null
	 */
	public function Current() 
	{
		if( $this->IsDone() )
		{
			return null ;
		}
		else
		{
			return $this->aRecordSet->GetRow($this->nIdx,true) ;
		}
	}



	/**
	 * 迭代到上一个
	 * 
	 * @access	public
	 * @return	array,null
	 */
	public function Previous() 
	{
		if( $this->nIdx<0 )
		{
			return null ;
		}
		elseif($this->nIdx==0)
		{
			$this->nIdx-- ;
			return null ;
		}
		elseif($this->nIdx>0)
		{
			return $this->aRecordSet->GetRow(--$this->nIdx,true) ;
		}
		else
		{
			JCAT_ASSERT::ASSERT_(0,'!?') ;
		}
		
	}



	/**
	 * 迭代到下一个
	 * 
	 * @access	public
	 * @return	array,null
	 */
	public function Next() 
	{
		$nLastIdx = $this->aRecordSet->GetCount()-1 ;
		
		if( $this->nIdx>$nLastIdx )
		{
			return null ;
		}
		elseif($this->nIdx==$nLastIdx)
		{
			$this->nIdx++ ;
			return null ;
		}
		elseif($this->nIdx<$nLastIdx)
		{
			return $this->aRecordSet->GetRow(++$this->nIdx,true) ;
		}
		else
		{
			JCAT_ASSERT::ASSERT_(0,'!?') ;
		}
	}
	
	/**
	 * 跳到最后一个
	 * 
	 * @access	public
	 * @return	array
	 */
	public function Last() 
	{
		$nCount = $this->aRecordSet->GetCount() ;
		if( $nCount>=0 )
		{
			return null ;
		}
		return $this->aRecordSet->GetRow($this->nIdx=$nCount-1,true) ;
	}



	/**
	 * 判断迭代是否完成
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function IsDone() 
	{
		$nLastIdx = $this->aRecordSet->GetCount()-1 ;
		return ( ($this->nIdx<0) or ($this->nIdx>$nLastIdx) ) ;
	}


	/**
	 * 返回当前行指定的字段
	 * 
	 * @access	public
	 * @param	$sColumnName	string 字段名稱
	 * @return	string,null
	 */
	public function GetField( $sColumnName ) 
	{
		JCAT_ASSERT::ASSERT_STRING($sColumnName) ;
		
		$arrRow = $this->Current() ;
		if(!$arrRow)
		{
			return null ;
		}
		
		if( !isset($arrRow[$sColumnName]) )
		{
			throw new JCAT_Exception( JCAT_Language::SentenceEx('指定的字段不存在：“%s”','JCAT',null,$sColumnName), __macro_exception_code__ ) ;
		}
		
		return $arrRow[$sColumnName] ;
	}

	/**
	 * 为当前行创建并返回一个字段迭代器
	 * 
	 * @access	public
	 * @return	JCAT_ArrayIterator,null
	 */
	public function CreateFieldIterator() 
	{		
		$arrRow = $this->Current() ;
		if(!$arrRow)
		{
			return null ;
		}
			
		return new JCAT_ArrayIterator($arrRow) ;
	}





	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 记录集
	 * 
	 * @access	private
	 * @var		JCAT_DBRecordSet
	 */
	private $aRecordSet ;
	
	/**
	 * 指针
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nIdx = -1 ;


}

?>