<?php
// Call JCAT_DBSubSQLConditionTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_DBSubSQLConditionTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/桌面/lib.php/Common/DB/DBSQL/DBSubSQL/class.JCAT_DBSubSQLCondition.php';

/**
 * Test class for JCAT_DBSubSQLCondition.
 * Generated by PHPUnit on 2007-12-25 at 12:20:53.
 */
class JCAT_DBSubSQLConditionTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_DBSubSQLConditionTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testMakeSQL().
     */
    public function testMakeSQL()
	{
		
				$aFactory = JCAT_Singleton::GetGlobalInstance('JCAT_DBFactoryMySQL41') ;
		
		$sCondition = $aFactory->CreateSubSQLCondition(null,"33",'aaa') ;
		$this->assertEquals( $sCondition->MakeSQL(), "'33' = 'aaa'" ) ;
		
		$sCondition = $aFactory->CreateSubSQLCondition(null,33,'aaa') ;
		$this->assertEquals( $sCondition->MakeSQL(), "33 = 'aaa'" ) ;
		
		$sCondition = $aFactory->CreateSubSQLCondition(null,33,true) ;
		$this->assertEquals( $sCondition->MakeSQL(), "33 = '1'" ) ;
		
		$sCondition = $aFactory->CreateSubSQLCondition(null,33,false) ;
		$this->assertEquals( $sCondition->MakeSQL(), "33 = '0'" ) ;
		
		$sCondition = $aFactory->CreateSubSQLCondition(null,33,false,'>=') ;
		$this->assertEquals( $sCondition->MakeSQL(), "33 >= '0'" ) ;
		
		
		$aColumn = $aFactory->CreateColumn('aaa','bbb') ;
		$sCondition = $aFactory->CreateSubSQLCondition(null,33,$aColumn,'>=') ;
		$this->assertEquals( $sCondition->MakeSQL(), "33 >= `bbb`.`aaa`" ) ;
		
		// 函数调用
		$aFunctionCall = $aFactory->CreateFunctionCall('func',array($aColumn)) ;
		$sCondition = $aFactory->CreateSubSQLCondition(null,33,$aFunctionCall,'>=') ;
		$this->assertEquals( $sCondition->MakeSQL(), "33 >= func( `bbb`.`aaa` )" ) ;
		
		
		
    }

    /**
     * @todo Implement testGetParentGroup().
     */
    public function testGetParentGroup() {
	
				$aFactory = JCAT_Singleton::GetGlobalInstance('JCAT_DBFactoryMySQL41') ;
		
		$sCondition = $aFactory->CreateSubSQLCondition(null,"33",'aaa') ;
		$this->assertEquals($sCondition->GetParentGroup(),null) ;
		
		
    }
}

// Call JCAT_DBSubSQLConditionTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_DBSubSQLConditionTest::main')
	JCAT_DBSubSQLConditionTest::main();
?>
