<?php
// Call JCAT_DBSubSQLConditionGroupTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_DBSubSQLConditionGroupTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/桌面/lib.php/Common/DB/DBSQL/DBSubSQL/class.JCAT_DBSubSQLConditionGroup.php';

/**
 * Test class for JCAT_DBSubSQLConditionGroup.
 * Generated by PHPUnit on 2007-12-25 at 12:21:09.
 */
class JCAT_DBSubSQLConditionGroupTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_DBSubSQLConditionGroupTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testJCAT_DBSQLConditionGroup().
     */
    public function testLogicComment() {
	
				$aFactory = JCAT_Singleton::GetGlobalInstance('JCAT_DBFactoryMySQL41') ;
		
		$aConditionGroup = $aFactory->CreateSubSQLConditionGroup(true,null,'comment:aaa') ;
		
		$this->assertEquals($aConditionGroup->GetLogic(),true) ;
		$this->assertEquals($aConditionGroup->GetLogic(false),'AND') ;
		$this->assertEquals($aConditionGroup->SetLogic(false),true) ;
		
		$this->assertEquals($aConditionGroup->GetLogic(),false) ;
		$this->assertEquals($aConditionGroup->GetLogic(false),'OR') ;
		
		$this->assertEquals($aConditionGroup->SetLogic(true),false) ;
		
		
		
		$this->assertEquals($aConditionGroup->GetComment(),'comment:aaa') ;
		$this->assertEquals($aConditionGroup->SetComment('comment:bbb'),'comment:aaa') ;
		$this->assertEquals($aConditionGroup->GetComment(),'comment:bbb') ;
    }

    /**
     * @todo Implement testAddCondition().
     */
    public function testMakeSQL() {
	
				$aFactory = JCAT_Singleton::GetGlobalInstance('JCAT_DBFactoryMySQL41') ;
		
		$aConditionGroup = $aFactory->CreateSubSQLConditionGroup(true,null,'comment:aaa') ;
		
		// 空条件组
		$this->assertEquals( $aConditionGroup->MakeSQL(), null ) ;
		
		
		$sConditionA = $aFactory->CreateSubSQLCondition(null,"33",'aaa') ;
		
		// 只有一项，不够成组
		$aConditionGroup->AddCondition($sConditionA) ;
		$this->assertEquals( $aConditionGroup->MakeSQL(), "'33' = 'aaa'" ) ;
		
		// 有两项
		$sConditionB = $aFactory->CreateSubSQLCondition(null,33,'aaa') ;
		$aConditionGroup->AddCondition($sConditionB) ;
		$this->assertEquals( $aConditionGroup->MakeSQL(), "(/*comment:aaa*/ '33' = 'aaa' AND 33 = 'aaa' )" ) ;
		
		// 清除
		$this->assertEquals( $aConditionGroup->ClearCondition(), 2 ) ;
		$this->assertEquals( $aConditionGroup->MakeSQL(), null ) ;
		
		
		$aConditionGroup2 = $aFactory->CreateSubSQLConditionGroup(true,$aConditionGroup,'comment:bb') ;
		$aConditionGroup3 = $aFactory->CreateSubSQLConditionGroup(false,$aConditionGroup2,'comment:cc') ;
		$aConditionGroup->AddCondition( $aConditionGroup2 ) ;
		$aConditionGroup2->AddCondition( $aConditionGroup3 ) ;
		
		// 连同下级条件组 均为空
		$this->assertEquals( $aConditionGroup->MakeSQL(), null ) ;


		// GetTopGroup
		$this->assertEquals($aConditionGroup->GetParentGroup(),null) ;
		$this->assertEquals($aConditionGroup->GetTopGroup(),$aConditionGroup) ;
		$this->assertEquals($aConditionGroup2->GetTopGroup(),$aConditionGroup) ;
		$this->assertEquals($aConditionGroup3->GetTopGroup(),$aConditionGroup) ;
		
		$aColumn = $aFactory->CreateColumn('cc.bb') ;
		$sConditionC = $aFactory->CreateSubSQLCondition(null,'bb',true, '!=') ;
		$sConditionD = $aFactory->CreateSubSQLCondition(null,$aColumn,'aaa') ;
		
		$aConditionGroup3->AddCondition($sConditionA) ;
		$aConditionGroup3->AddCondition($sConditionC) ;
		$aConditionGroup2->AddCondition($sConditionB) ;
		$aConditionGroup->AddCondition($sConditionD) ;
		
		$this->assertEquals( $aConditionGroup->MakeSQL(), "(/*comment:aaa*/ (/*comment:bb*/ (/*comment:cc*/ '33' = 'aaa' OR 'bb' != '1' ) AND 33 = 'aaa' ) AND `cc`.`bb` = 'aaa' )" ) ;
    }


}

// Call JCAT_DBSubSQLConditionGroupTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_DBSubSQLConditionGroupTest::main')
	JCAT_DBSubSQLConditionGroupTest::main();
?>
