<?php
// Call JCAT_DBSubSQLOrderTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_DBSubSQLOrderTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/桌面/lib.php/Common/DB/DBSQL/DBSubSQL/class.JCAT_DBSubSQLOrder.php';

/**
 * Test class for JCAT_DBSubSQLOrder.
 * Generated by PHPUnit on 2007-12-24 at 18:39:02.
 */
class JCAT_DBSubSQLOrderTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_DBSubSQLOrderTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testMakeSQL().
     */
    public function testMakeSQL() {
	
				$aFactory = JCAT_Singleton::GetGlobalInstance('JCAT_DBFactoryMySQL41') ;
		
		$aOrder = $aFactory->CreateSubSQLOrder() ;
		$this->assertEquals( '', $aOrder->MakeSQL() ) ;
		
		$aOrder->AddOrder('a') ;
		$this->assertEquals( ' ORDER BY `a`', $aOrder->MakeSQL() ) ;
		
		$aClm = $aFactory->CreateColumn('bbb','ccc') ;
		$aOrder->AddOrder($aClm) ;
		$this->assertEquals( ' ORDER BY `a`, `ccc`.`bbb`', $aOrder->MakeSQL() ) ;
		
		$aClm = $aFactory->CreateColumn('ddd') ;
		$aOrder->AddOrder($aClm,true) ;
		$this->assertEquals( ' ORDER BY `a`, `ccc`.`bbb`, `ddd` DESC', $aOrder->MakeSQL() ) ;
		
		$aOrder->ClearOrder() ;
		$this->assertEquals( '', $aOrder->MakeSQL() ) ;
		
    }
}

// Call JCAT_DBSubSQLOrderTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_DBSubSQLOrderTest::main')
	JCAT_DBSubSQLOrderTest::main();
?>
