<?php
// Call JCAT_DBSubSQLWhereTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_DBSubSQLWhereTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/桌面/lib.php/Common/DB/DBSQL/DBSubSQL/class.JCAT_DBSubSQLWhere.php';

/**
 * Test class for JCAT_DBSubSQLWhere.
 * Generated by PHPUnit on 2007-12-25 at 15:41:57.
 */
class JCAT_DBSubSQLWhereTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_DBSubSQLWhereTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testMakeSQL().
     */
    public function testMakeSQL() {
	
	
		
    }


    /**
     * @todo Implement testAddGroup().
     */
    public function testAddGroup() {
        // Remove the following lines when you implement this test.
        $this->markTestIncomplete(
          'This test has not been implemented yet.'
        );
    }

    /**
     * @todo Implement testSetActiveGroup().
     */
    public function testTopActiveGroup() {
        
				$aFactory = JCAT_Singleton::GetGlobalInstance('JCAT_DBFactoryMySQL41') ;
		
		$aWhere = $aFactory->CreateSubSQLWhere() ;
		$this->assertEquals( $aWhere->GetActiveGroup(), $aWhere->GetTopGroup() ) ;
		$this->assertEquals( $aWhere->MakeSQL(), '' ) ;
		
		// 创建一个 新的条件组
		$aActiveGroup = $aWhere->GetActiveGroup() ;
		$aGroup1 = $aWhere->AddGroup() ;
		$this->assertNotEquals( $aWhere->GetActiveGroup(), $aActiveGroup ) ;
		$aActiveGroup = $aWhere->GetActiveGroup() ;
		
		
		// 返回 上级 组
		$this->assertEquals( $aWhere->BackParentGroup(), $aActiveGroup ) ;
		$this->assertEquals( $aWhere->GetActiveGroup(), $aWhere->GetTopGroup() ) ;
		$aActiveGroup = $aWhere->GetActiveGroup() ;
		
		// 无上级组
		$this->assertEquals( $aWhere->BackParentGroup(), null ) ;
		$this->assertEquals( $aWhere->GetActiveGroup(), $aWhere->GetTopGroup() ) ;
		$this->assertEquals( $aWhere->GetActiveGroup(), $aActiveGroup ) ;
		
		// 创建一个 新的条件组
		$aGroup2 = $aWhere->AddGroup() ;
		
		$aWhere->AddCondition("33",'aaa') ;
		$aWhere->AddCondition(44,'bb','!=') ;
		
		$this->assertEquals( $aWhere->MakeSQL(), " WHERE ( '33' = 'aaa' AND 44 != 'bb' )" );
		
		// 继续添加条件
		$this->assertEquals( $aWhere->BackParentGroup(), $aGroup2 ) ;
		$aWhere->AddCondition('cc',false,'!=') ;
		
		$this->assertEquals( $aWhere->MakeSQL(), " WHERE ( ( '33' = 'aaa' AND 44 != 'bb' ) AND 'cc' != '0' )" );
		
		$aWhere->SetLogic(false) ;
		$this->assertEquals( $aWhere->MakeSQL(), " WHERE ( ( '33' = 'aaa' AND 44 != 'bb' ) OR 'cc' != '0' )" );
		
    }
}

// Call JCAT_DBSubSQLWhereTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_DBSubSQLWhereTest::main')
	JCAT_DBSubSQLWhereTest::main();
?>
