<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBSubSQLCondition.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 条件子句
 *
 * @author		alee
 * @access		public
 */
if( !class_exists('JCAT_DBSubSQLCondition') )
{
	class JCAT_DBSubSQLCondition extends JCAT_DBSQL
	{

		/**
		 * 
		 * @access	public
		 * @param	$aFactory			JCAT_DBAbstractFactory					对象工厂
		 * @param	$aParent			JCAT_DBSubSQLConditionGroup,null		条件组子句
		 * @param	$Left				JCAT_DBGenericTypes::$ConditionObject	操作符 左边 的对象
		 * @param	$Right				JCAT_DBGenericTypes::$ConditionObject	操作符 右边 的对象
		 * @param	$sOperator='='		string									操作符号
		 * @param	$RightB=null		JCAT_DBGenericTypes::$ConditionObject	用于三目运算的 右边第二个参数
		 * @return	void
		 */
		public function JCAT_DBSubSQLCondition( JCAT_DBAbstractFactory $aFactory, $aParent, $Left, $Right, $sOperator='=', $RightB=null ) 
		{
			// 参数 类型 检查 
			JCAT_ASSERT::ASSERT_STRING('$sOperator') ;
			JCAT_ASSERT::ASSERT_ISTHESE($aParent,array('JCAT_DBSubSQLConditionGroup','null')) ;
			
			$this->aParent = $aParent ;			// print_r($Left) ;
			$this->Left = JCAT_DBGenericTypes::TransConditionObject($Left) ;
			$this->Right = JCAT_DBGenericTypes::TransConditionObject($Right) ;
			$this->sOperator = $sOperator ;
			$this->RightB = $RightB ;
			
			$this->SetFactory($aFactory) ;
		}



		/**
		 * 创建并返回SQL语句
		 * 
		 * @access	public
		 * @return	string
		 */
		public function MakeSQL()
		{
			$sSQL = $this->TransObjectToString($this->Left) .
						" {$this->sOperator} " .
						$this->TransObjectToString($this->Right) ;
			
			if( $this->sOperator==='BETWEEN' )
			{
				$sSQL.= " AND {$this->RightB}" ;
			}
			
			return $sSQL ;
		}

		/**
		 * 将一个条件操作对象，转换成 字符格式
		 * 
		 * @access	public
		 * @param	$Object		JCAT_DBGenericTypes::$ConditionObject 
		 * @return	string
		 */
		private function TransObjectToString($Object)
		{
			if( is_object($Object) )
			{
				return $Object->MakeSQL() ;
			}
			
			else 
			{
				return $Object ;
			}
		}

		/**
		 * 返回所属 条件组
		 * 
		 * @access	public
		 * @return	JCAT_DBSubSQLConditionGroup
		 */
		public function GetParentGroup() 
		{ return $this->aParentGroup ; }




		// 属性 ///////////////////////////////////////////////////////////////////////////////

		/**
		 * 所属条件组
		 * 
		 * @access	private
		 * @var		JCAT_DBSubSQLConditionGroup
		 */
		protected $aParentGroup = null ;


		private $Left ;
		private $Right ;
		private $sOperator ;
		private $RightB ;

	}
}


/*macro_exception_code:2*/
?>