<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBSubSQLConditionGroup.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * SQL 条件组
 *
 * @author		alee
 * @access		public
 */
if( !class_exists('JCAT_DBSubSQLConditionGroup') )
{
	class JCAT_DBSubSQLConditionGroup extends JCAT_DBSubSQLCondition
	{
		/**
		 * 
		 * @access	public
		 * @param	$aFactory		JCAT_DBAbstractFactory				对象工厂
		 * @param	$bLogic=true	bool								条件组内 各条件的 逻辑关系
		 * @param	$aParent=null	JCAT_DBSubSQLConditionGroup,null	所属条件组
		 * @param	$sComment=''	string								注释
		 * @return	
		 */
		public function JCAT_DBSubSQLConditionGroup(  JCAT_DBAbstractFactory $aFactory, $bLogic=true, $aParent=null,  $sComment='' ) 
		{
			JCAT_ASSERT::ASSERT_BOOL($bLogic) ;
			JCAT_ASSERT::ASSERT_STRING($sComment) ;
			JCAT_ASSERT::ASSERT_ISTHESE($aParent,array('JCAT_DBSubSQLConditionGroup','null')) ;
			
			$this->bLogic = $bLogic ;
			$this->aParentGroup = $aParent ;
			$this->sComment = $sComment ;
			
			$this->SetFactory($aFactory) ;
		}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function __clone()
	{
		$arrNewArray = array() ;
		foreach ($this->arrChildren as $Child)
		{
			if(is_object($Child))
			{
				$arrNewArray[] = clone $Child ;
			}
			
			else
			{
				$arrNewArray[] = $Child ;
			}
		}
		$this->arrChildren = $arrNewArray ;
		
		
	}
	
		/**
		 * 递归返回顶极条件组
		 * 
		 * @access	public
		 * @return	JCAT_DBSubSQLConditionGroup
		 */
		function GetTopGroup()
		{
			$aParent = $this->GetParentGroup() ;
			if(!$aParent)
				return $this ;
			else
				return $aParent->GetTopGroup() ;
		}

		/**
		 * 创建并返回SQL语句
		 * 如果 条件组 及其 下级条件组 均为空，则 返回 null
		 * 
		 * @access	public
		 * @return	string,null
		 */
		public function MakeSQL()
		{
			$arrMemberSQLs = array() ;
			foreach($this->arrChildren as $Member)
			{				
				if( is_string($Member) )
				{
					$sSQLCondition = $Member ;
				}
				else
				{
					$sSQLCondition = $Member->MakeSQL() ;
				}
				
				// 过滤 空的内容
				if( $sSQLCondition===null )
				{
					continue ;
				}
				$arrMemberSQLs[] = $sSQLCondition ;
			}
			
			$nMemberCount = count($arrMemberSQLs) ;
			
			
			// 多余一项内容
			if( $nMemberCount>1 )
			{
				if( $sComment=$this->GetComment() )
					$sComment = "/*{$sComment}*/" ;
				return "({$sComment} ". implode( ' '.$this->GetLogic(false).' ', $arrMemberSQLs ) . ' )' ;
			}
			
			// 只有一项内容 不够成条件组，直接返回 该项内容
			else if( $nMemberCount==1 )
				return $arrMemberSQLs[0] ;
			
			// 空 条件组
			else
				return null ;
		}



		/**
		 * 加入一个条件 或 条件组
		 * 
		 * @access	public
		 * @param	$aConditionOrGroup	JCAT_DBSubSQLCondition	加入成员
		 * @return	void
		 */
		public function AddCondition( $aConditionOrGroup ) 
		{
			if( !JCAT_Global::IsKindOf($aConditionOrGroup,'JCAT_DBSubSQLCondition') )
			{
				throw new JCAT_Exception( JCAT_Language::SentenceEx('参数 $aConditionOrGroup 必须为条件（JCAT_DBSubSQLCondition）或条件组（JCAT_DBSubSQLConditionGroup）','JCAT',null), JCAT_Exception::MakeExceptionCode(__CLASS__,1) ) ;
			}
			
			$this->arrChildren[] = $aConditionOrGroup ;
		}
	
		/**
		 * 加入一个字符格式的条件
		 * 
		 * @access	public
		 * @param	$sCondition		string
		 * @return	void
		 */
		public function AddStringCondition( $sCondition ) 
		{
			JCAT_ASSERT::ASSERT_STRING($sCondition) ;
			$this->arrChildren[] = $sCondition ;
		}
		
		/**
		 * 清空组内条件
		 * 
		 * @access	public
		 * @return	int
		 */
		public function ClearCondition() 
		{
			$nRet = $this->GetConditionCount() ;
			$this->arrChildren = array() ;
			return $nRet ;
		}

		/**
		 * 返回 组内 条件/条件组  的数量
		 * 
		 * @access	public
		 * @return	int
		 */
		public function GetConditionCount()
		{ return count($this->arrChildren) ; }


		/**
		 * 设置逻辑关系
		 * 
		 * @access	public
		 * @param	$bAND=true	bool	关系为 AND
		 * @return	old_value
		 */
		public function SetLogic( $bAND=true ) 
		{
			JCAT_ASSERT::ASSERT_BOOL($bAND) ;
		
			$old_value = $this->bLogic ;
			$this->bLogic = $bAND ;
			return $old_value ;
		}



		/**
		 * 返回 组逻辑
		 * 
		 * @access	public
		 * @param	$bReturnBool=true		bool	以布尔值 返回
		 * @return	string,bool
		 */
		public function GetLogic(  $bReturnBool=true ) 
		{
			if($bReturnBool)
				return $this->bLogic ;
			else
				return $this->bLogic? 'AND': 'OR' ;
		}



		/**
		 * 返回备注
		 * 
		 * @access	public
		 * @return	string
		 */
		public function GetComment(  ) 
		{ return $this->sComment ; }



		/**
		 * 设置备注
		 * 
		 * @access	public
		 * @param	$sComment	string	备注内容
		 * @return	old_value
		 */
		public function SetComment(  $sComment ) 
		{
			JCAT_ASSERT::ASSERT_STRING($sComment) ;
		
			$old_value = $this->sComment ;
			$this->sComment = $sComment ;
			return $old_value ;
		}




		// 属性 ///////////////////////////////////////////////////////////////////////////////

		/**
		 * 组内逻辑关系
		 * 
		 * @access	private
		 * @var		string
		 */
		private $bLogic = true ;

		/**
		 * 组内条件
		 * 
		 * @access	private
		 * @var		array:JCAT_DBSubSQLCondition,JCAT_DBSubSQLConditionGroup
		 */
		private $arrChildren = array() ;

		/**
		 * 注释
		 * 
		 * @access	public
		 * @var		string
		 */
		private $sComment ;


		/**
		 * 条件组全局ID
		 * 
		 * @access	public
		 * @var		int
		 */
		private $nId = -1 ;
	}
}


/*macro_exception_code:1*/
?>