<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBSubSQLFrom.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * SQL From 子句
 *
 * @author		alee
 * @access		public
 */
class JCAT_DBSubSQLFrom extends JCAT_DBSQL
{

	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function __clone()
	{
		$arrNewTables = array() ;
		foreach ($this->arrTables as $Table)
		{
			if(is_object($Table))
			{
				$arrNewTables[] = clone $Table ;
			}
			
			else
			{
				$arrNewTables[] = $Table ;
			}
		}
		$this->arrTables = $arrNewTables ;
	}

	/**
	 * 加入一个数据表
	 * 
	 * @access	public
	 * @param	$Table		GENERIC_DBTable	数据表
	 * @return	
	 */
	public function AddTable( $Table )
	{
		$aTableIns = JCAT_DBGenericTypes::TransTable( $this->GetFactory(), $Table ) ;
		$this->arrTables[] = $aTableIns ;
	}



	/**
	 * 清空 From子句 中的 数据表
	 * 
	 * @access	public
	 * @return	int
	 */
	public function ClearFrom() 
	{
		$nRet = count($this->arrTables) ;
		$this->arrTables = array() ;
		return $nRet ;
	}

	/**
	 * 创建并返回SQL语句
	 * 
	 * @access	public
	 * @return	string
	 */
	public function MakeSQL()
	{
		if( !count($this->arrTables)  )
		{
			$aFactory = $this->GetFactory() ;
			throw $aFactory->CreateException( JCAT_Language::SentenceEx('SQL 的 From 尚未设置数据表。','JCAT',null), JCAT_Exception::MakeExceptionCode(__CLASS__,1) ) ;
		}


		$arrTables = array() ;
		foreach($this->arrTables as $aTable)
		{
			JCAT_ASSERT::ASSERT_ISTHESE($aTable,array('JCAT_DBTable','JCAT_DBTableJoin','JCAT_DBTableSelectResult')) ;
			$arrTables[] = $aTable->MakeSQL(true) ;
		}
		
		return implode(', ',$arrTables) ;
	}



	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * What's this Attribute ?
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrTables ;


}
/*macro_exception_code:1*/
?>