<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBSubSQLWhere.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * SQL Where 子句
 *
 * @author		alee
 * @access		public
 */
class JCAT_DBSubSQLWhere extends JCAT_DBSQL
{
	/**
	 * 
	 * @access	public
	 * @param	$aFactory		JCAT_DBAbstractFactory		对象具体工厂，用于创建 SQL子句
	 * @return	void
	 */
	public function JCAT_DBSubSQLWhere( JCAT_DBAbstractFactory $aFactory )
	{
		$this->SetFactory($aFactory) ;
		$this->aTopGroup = $aFactory->CreateSubSQLConditionGroup() ;
		$this->aActiveGroup = $this->aTopGroup ;
	}

	/**
	 * 创建并返回SQL语句
	 * 如果 子句中 没有设置任何条件， 返回一个空的字符串
	 * 
	 * @access	public
	 * @return	string
	 */
	public function MakeSQL()
	{
		$theTopGroup = $this->GetTopGroup() ;
		JCAT_ASSERT::ASSERT_INSTANCE($theTopGroup,'JCAT_DBSubSQLConditionGroup') ;
		
		$sSQL = $theTopGroup->MakeSQL() ;
		
		return ($sSQL===null)? '': " WHERE {$sSQL}" ;
	}


	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function __clone()
	{
		$this->aTopGroup = clone $this->aTopGroup ;
		$this->aActiveGroup = $this->aTopGroup ;
	}

	/**
	 * 创建添加一项条件，并返回 此条件
	 * 
	 * @access	public
	 * @param	$Lft				JCAT_DBGenericTypes::$ConditionObject		操作符 左边 的对象
	 * @param	$Rgt=''				JCAT_DBGenericTypes::$ConditionObject		操作符 右边 的对象
	 * @param	$sOperator='='		string										操作符号
	 * @param	$RightB=null			JCAT_DBGenericTypes::$ConditionObject		用于三目运算的 右边第二个参数
	 * @return	JCAT_DBSubSQLCondition
	 */
	public function AddCondition( $Lft, $Rgt='', $sOperator='=', $RightB=null ) 
	{
		$aFactory = $this->GetFactory() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aFactory,'JCAT_DBAbstractFactory') ;
				
		$aGroup = $this->GetActiveGroup() ;
		$aCondition = $aFactory->CreateSubSQLCondition( $aGroup, $Lft, $Rgt, $sOperator, $RightB ) ;
		
		$aGroup->AddCondition($aCondition) ;
		return $aCondition ;
	}


	/**
	 * 创建添加一项字符格式的条件
	 * 
	 * @access	public
	 * @param	$sCondition		string
	 * @return	void
	 */
	public function AddStringCondition( $sCondition ) 
	{
		$aGroup = $this->GetActiveGroup() ;
		$aGroup->AddStringCondition($sCondition) ;
		return ;
	}

	/**
	 * 新创建一个条件组，同时将新创建的条件组设为 “当前条件组”，并返回 此条件组
	 * 
	 * @access	public
	 * @param	$bAND		bool		逻辑关系
	 * @return	JCAT_DBSubSQLConditionGroup
	 */
	public function AddGroup($bAND=true) 
	{
		// 当前组
		$aActiveGroup = $this->GetActiveGroup() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aActiveGroup,'JCAT_DBSubSQLConditionGroup') ;
		
		// 对象工厂
		$aFactory = $this->GetFactory() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aFactory,'JCAT_DBAbstractFactory') ;
	
		// 创建新对象
		$aGroup = $aFactory->CreateSubSQLConditionGroup($bAND,$aActiveGroup) ;

		// 加入到  Where 子句中
		$aActiveGroup->AddCondition($aGroup) ;
		
		// 返回
		$this->SetActiveGroup($aGroup) ;
		return $aGroup ;
	}
	
	
	/**
	 * 设置一个条件组为 当前条件组
	 * 
	 * @access	public
	 * @param	$aGroup	JCAT_DBSubSQLConditionGroup	条件组
	 * @return	$old_value
	 */
	public function SetActiveGroup( JCAT_DBSubSQLConditionGroup $aGroup ) 
	{
		if( !$aGroup->GetTopGroup()==$this->GetTopGroup() )
		{
			throw new JCAT_Exception( JCAT_Language::SentenceEx('传入的条件组对象，尚未加入到此Where子句中。','JCAT',null), __macro_exception_code__ ) ;
		}
		
		$old_value = $this->aActiveGroup ;
		$this->aActiveGroup = $aGroup ;
		return $old_value ;
	}


	/**
	 * 返回当前条件组
	 * 
	 * @access	public
	 * @return	JCAT_DBSubSQLConditionGroup
	 */
	public function GetActiveGroup()
	{ return $this->aActiveGroup ; }


	/**
	 * 返回顶极条件组
	 * 
	 * @access	public
	 * @return	JCAT_DBSubSQLConditionGroup
	 */
	public function GetTopGroup()
	{ return $this->aTopGroup ; }


	/**
	 * 回到上级条件组，并返回上级条件组，如果无上级，返回 null
	 * 
	 * @access	public
	 * @return	JCAT_DBSubSQLConditionGroup,null
	 */
	public function BackParentGroup() 
	{
		$aGroup = $this->GetActiveGroup() ;
		$aParent = $aGroup->GetParentGroup() ;
		
		if($aParent)
			return $this->SetActiveGroup($aParent) ;

		else
			return null ;
	}



	/**
	 * 设置条件组 逻辑关系
	 * 
	 * @access	public
	 * @param	$bAND=true			What's this Parameter ?
	 * @return	old_value
	 */
	public function SetGroupLogic( $bAND=true ) 
	{
		$aGroup = $this->GetActiveGroup() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aGroup,'JCAT_DBSubSQLConditionGroup') ;
		
		return $aGroup->SetLogic($bAND) ;
	}



	/**
	 * 返回条件组逻辑关系
	 * 
	 * @access	public
	 * @param	$bReturnBool=true		bool	以布尔值 返回
	 * @return	bool,string
	 */
	public function GetGroupLogic( $bReturnBool=true ) 
	{
		$aGroup = $this->GetActiveGroup() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aGroup,'JCAT_DBSubSQLConditionGroup') ;
		
		return $aGroup->GetLogic($bReturnBool) ;
	}

	
	/**
	 * 清空 当前条件组 内的条件
	 * 
	 * @access	public
	 * @return	int
	 */
	public function ClearCondition() 
	{
		return $this->GetActiveGroup()->ClearCondition() ;
	}



	/**
	 * 设置 当前条件组的 逻辑关系
	 * 
	 * @access	public
	 * @param	$bAND=true	bool	关系为 AND
	 * @return	old_value
	 */
	public function SetLogic( $bAND=true ) 
	{
		return $this->GetActiveGroup()->SetLogic($bAND) ;
	}



	/**
	 * 返回 当前条件组的 逻辑关系
	 * 
	 * @access	public
	 * @param	$bReturnBool=true		bool	以布尔值 返回
	 * @return	string,bool
	 */
	public function GetLogic(  $bReturnBool=true ) 
	{
		return $this->GetActiveGroup()->GetLogic($bReturnBool) ;
	}



	/**
	 * 返回当前条件组的备注
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetComment(  ) 
	{ return $this->GetActiveGroup()->GetComment() ; }



	/**
	 * 设置当前条件组的备注
	 * 
	 * @access	public
	 * @param	$sComment	string	备注内容
	 * @return	old_value
	 */
	public function SetComment(  $sComment ) 
	{ return $this->GetActiveGroup()->SetComment($sComment) ; }
		

	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 顶极 Group 的引用
	 * 
	 * @access	private
	 * @var		JCAT_DBSubSQLConditionGroup
	 */
	private $aTopGroup ;

	/**
	 * 但前 Group 的引用
	 * 
	 * @access	private
	 * @var		JCAT_DBSubSQLGroup
	 */
	private $aActiveGroup = null ;


}
?>