<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBSQLCreate.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/





/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 * @last		2007.12.6
 */
abstract class JCAT_DBSQLCreate extends JCAT_DBSQL
{
	
	const BIN = 1 ;
	const UNSIGNED = 3 ;
	const ZEROFULL = 7 ;
	
	const NOTNULL = 8 ;
	
	const PRIMARY = 16 ;
	const AUTOINCREMENT = 48 ;
	const INDEX = 64 ;
	const UNIQUE = 128 ;
	const FULLTEXT = 256 ;

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sTableName		string
	 * @return	void
	 */
	public function JCAT_DBSQLCreate(JCAT_IDBAbstractFactory $aFactory,$sTableName)
	{
		$this->JCAT_DBSQL($aFactory) ;
		
		JCAT_ASSERT::ASSERT_STRING($sTableName);
		$this->sTableName = $sTableName ;		
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetTable()
	{
		return $this->sTableName ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sClmName
	 * @param	$sClmType
	 * @param	$nLength
	 * @param	$sDefault=null
	 * @param	$nFlag=0
	 * @param	$arrOption=array()
	 * 
	 * @return	void
	 */
	public function AddColumn($sClmName,$sClmType,$nLength,$sDefault=null,$nFlag=0,$arrOption=array())
	{
		$arrClm = $arrOption ;
		$arrClm['name'] = $sClmName ;
		$arrClm['type'] = $sClmType ;
		$arrClm['default'] = $sDefault ;
		$arrClm['length'] = $nLength ;
		$arrClm['flag'] = $nFlag ;
		
		$this->arrClms[$arrClm['name']] = $arrClm ;
		
		// auto add index by column flag
		$this->AutoAddIndexByFlag($sClmName,$nFlag) ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @param	$sColumnName
	 * @param	$nColumnFlag
	 * @return	void
	 */
	protected function AutoAddIndexByFlag($sColumnName,$nColumnFlag)
	{
		foreach (self::$arrIndexTypes as $sIndexType)
		{
			if( $nColumnFlag&constant(__CLASS__.'::'.$sIndexType) )
			{
				$this->AddIndex($sIndexType,$sColumnName,array($sColumnName));
			}
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sIndexType
	 * @return	bool
	 */
	public function VerifyIndexType($sIndexType)
	{
		return in_array($sIndexType,self::$arrIndexTypes) ;	
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sType				string
	 * @param	$sName				string
	 * @param	$arrColumns=		array
	 * @return	void
	 */
	public function AddIndex($sType,$sName,array $arrColumns)
	{
		if( !$this->VerifyIndexType($sType) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'正在数据表设置一个类型无效的索引:(%s:%s)'
				, 'JCAT', null
				, $sType, $sName
			)) ;	
		}
		
		$this->arrIndexes[] = array(
				'type' => $sType
				, 'name' => $sName
				, 'columns' => $arrColumns
		) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateIndexIterator()
	{
		return new JCAT_ArrayIterator($this->arrIndexes) ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	string
	 */
	protected function MakeSQLFlags($nClmFlag)
	{
		$sSQL = '' ;
		
		foreach (self::$arrFlagWords as $nFlag=>$sSQLWord)
		{
			$sSQL.= ($nClmFlag&$nFlag)? $sSQLWord: '' ;
		}
		
		return $sSQL ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateColumnIterator()
	{
		return new JCAT_ArrayIterator($this->arrClms) ;
	}


	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sTableName ;
	
	
	private $arrClms = array() ;

	
	static private $arrFlagWords = array(
		parent::NOTNULL=>' NOT NULL'
		, parent::AUTOINCREMENT=>' AUTO_INCREMENT'
		
		, parent::BIN=>' BINARY'
		, parent::UNSIGNED=>' UNSIGNED'
		, parent::ZEROFULL=>' UNSIGNED ZEROFILL'
	) ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		array
	 */
	static private $arrIndexTypes = array(
			'PRIMARY'
			, 'INDEX'
			, 'UNIQUE'
			, 'FULLTEXT'
	) ;
}
?>