<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBSQLInsert.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * SQL Insert 语句
 *
 * @author		alee
 * @access		public
 */
class JCAT_DBSQLInsert extends JCAT_DBSQL
{


	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$aFactory		JCAT_DBAbstractFactory				对象工厂
	 * @param	$sTable				string	操作数据表
	 * @param	$bReplace=false		bool	Repalce 或 Insert 
	 * @return	
	 */
	public function JCAT_DBSQLInsert( JCAT_DBAbstractFactory $aFactory, $sTable=null, $bReplace=false ) 
	{		
		$this->JCAT_DBSQL($aFactory) ;
		
		if($sTable)
		{
			$this->SetTableName($sTable) ;
		}
		$this->bReplace = $bReplace ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sTableName
	 * @return	void
	 */
	public function SetTableName($sTableName)
	{
		JCAT_ASSERT::ASSERT_STRING($sTableName) ;
		$this->sTable = $sTableName ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetTableName()
	{
		return $this->sTable ;
	}
	
	/**
	 * 创建并返回SQL语句
	 * 
	 * @access	public
	 * @return	string
	 */
	public function MakeSQL()
	{
		if($this->bWholeRow)
		{
			$sColumns = '' ;
		}
		else
		{
			$sColumns = '('.implode(', ',array_keys($this->arrDatas)).')' ;
		}
		
		$sValues = '('.implode(', ',$this->arrDatas).')' ;

		$sType = $this->bReplace? 'REPLACE': 'INSERT' ;
		return "{$sType} INTO {$this->sTable} {$sColumns} VALUES {$sValues} ;" ;
	}


	/**
	 * 设置字段内容
	 * 
	 * @access	public
	 * @param	$ClmOrDatas		JCAT_DBGenericTypes::$Column,array	字段，或 值对数组
	 * @param	$Value=null		JCAT_DBGenericTypes::$Value			值
	 * @return	
	 */
	public function SetData( $ClmOrDatas, $Value=null )
	{
		if( is_array($ClmOrDatas) )
		{
			foreach($ClmOrDatas as $sClmName=>$Value)
			{
				$this->SetData($sClmName,$Value) ;
			}
		}
		
		else
		{
			$aClm = JCAT_DBGenericTypes::TransColumn($this->GetFactory(),$ClmOrDatas) ;
			$sValue = JCAT_DBGenericTypes::TransValue($Value) ;
			
			$this->arrDatas[$aClm->MakeSQL()] = $sValue ;
		}
	}



	/**
	 * 设置整行的内容，无需字段名
	 * 
	 * @access	public
	 * @param	$arrRow		array	整行值
	 * @return	
	 */
	public function SetWholeRow( array $arrRow )
	{
		$this->bWholeRow = true ;
		$this->arrDatas = $arrRow ;
	}




	// 属性 ///////////////////////////////////////////////////////////////////////////////

	private $sTable ;
	
	private $bReplace ;
	
	private $arrDatas = array() ;
	
	private $bWholeRow = false ;
}
?>