<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBSQLRecordsOperate.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 多行操作（select,update,delete, 不包括 insert） 的父类
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_DBSQLRecordsOperate extends JCAT_DBSQL
{


	/**
	 * 数据表
	 * 
	 * @access	public
	 * @param	$aFactory		JCAT_DBAbstractFactory				对象工厂
	 * @param	$Tables			JCAT_DBGenericTypes::$TableList		数据表
	 * @return	
	 */
	public function JCAT_DBSQLRecordsOperate( $aFactory, $Tables=array() ) 
	{
		// 参数校验
		JCAT_ASSERT::ASSERT_INSTANCE($aFactory,'JCAT_DBAbstractFactory') ;
		
		// 创建 各个子句对象
		$this->aSubSQLFrom = JCAT_DBGenericTypes::TransTableList($aFactory,$Tables) ;
		$this->aSubSQLWhere = $aFactory->CreateSubSQLWhere() ;
		$this->aSubSQLLimit = $aFactory->CreateSubSQLLimit() ;
		$this->aSubSQLOrder = $aFactory->CreateSubSQLOrder() ;
		
		JCAT_ASSERT::ASSERT_INSTANCE($this->aSubSQLFrom,'JCAT_DBSubSQLFrom') ;
		JCAT_ASSERT::ASSERT_INSTANCE($this->aSubSQLWhere,'JCAT_DBSubSQLWhere') ;
		JCAT_ASSERT::ASSERT_INSTANCE($this->aSubSQLLimit,'JCAT_DBSubSQLLimit') ;
		JCAT_ASSERT::ASSERT_INSTANCE($this->aSubSQLOrder,'JCAT_DBSubSQLOrder') ;
		
			
		// “透明围栏” 内 的对象
		$this->arrObjectsInTransparent[] = $this->aSubSQLWhere ;
		$this->arrObjectsInTransparent[] = $this->aSubSQLFrom ;
		$this->arrObjectsInTransparent[] = $this->aSubSQLLimit ;
		$this->arrObjectsInTransparent[] = $this->aSubSQLOrder ;

		$this->SetFactory($aFactory) ;
	}

	/**
	 * 编译SQL子句
	 *
	 * @access	protected
	 * @param	$sSubSQLName	string	
	 * @return	string
	 */
	protected function MakeSubSQL($sSubSQLName)
	{
		JCAT_ASSERT::ASSERT_( method_exists($this,'GetStringSubSQL'.$sSubSQLName)
				, JCAT_Language::SentenceEx('MakeSubSQL() 遇到意外的子句名称 %s','JCAT',null,$sSubSQLName))  ;
		
		$sStringSubSQL = call_user_func(array($this,'GetStringSubSQL'.$sSubSQLName)) ;
		$aObjectSubSQL = call_user_func(array($this,'GetSubSQL'.$sSubSQLName)) ;
		
		// 优先使用 字符类型的 子句
		if( $sStringSubSQL!==null )
		{
			return $sStringSubSQL ;
		}
		
		// 对象类型 子句
		else if( $aObjectSubSQL )
		{
			return $aObjectSubSQL->MakeSQL() ;
		}
		
		else
		{
			return '' ;
		}
	}


	public function __call($sMethod,$arrArgs)
	{		
		// “透明围栏” 内 的对象
		foreach($this->arrObjectsInTransparent as $aObject)
		{
			if( method_exists( $aObject, $sMethod ) )
			{
				return call_user_func_array( array($aObject,$sMethod), $arrArgs ) ;
			}
		}
		
		throw new JCAT_Exception( JCAT_Language::SentenceEx('正在访问不存在的方法：%s','JCAT',null,$sMethod), JCAT_Exception::MakeExceptionCode(__CLASS__,2) ) ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function __clone()
	{
		$this->aSubSQLFrom = clone $this->aSubSQLFrom ;
		$this->aSubSQLLimit = clone $this->aSubSQLLimit ;
		$this->aSubSQLOrder = clone $this->aSubSQLOrder ;
		$this->aSubSQLWhere = clone $this->aSubSQLWhere ;
		
		// “透明围栏” 内 的对象
		$this->arrObjectsInTransparent[] = $this->aSubSQLWhere ;
		$this->arrObjectsInTransparent[] = $this->aSubSQLFrom ;
		$this->arrObjectsInTransparent[] = $this->aSubSQLLimit ;
		$this->arrObjectsInTransparent[] = $this->aSubSQLOrder ;
	}
	
	//  For Sub SQL 'WHERE'  ///////////////////////////////////////////
	/**
	 * set sub sql 'where'
	 *
	 * @access	public
	 * @param 	$aSubSQLWhere	JCAT_DBSubSQLWhere
	 * @return	void
	 */
	public function SetSubSQLWhere(JCAT_DBSubSQLWhere $aSubSQLWhere)
	{
		$this->aSubSQLWhere = $aSubSQLWhere ;
	}

	/**
	 * get sub sql 'where'
	 *
	 * @access	public
	 * @return	JCAT_DBSubSQLWhere
	 */
	public function GetSubSQLWhere()
	{
		return $this->aSubSQLWhere ;
	}

	/**
	 * set string format sub sql 'where'
	 *
	 * @access	public
	 * @param 	$sSubSQLWhere	string
	 * @return	void
	 */
	public function SetStringSubSQLWhere($sSubSQLWhere)
	{
		$this->sSubSQLWhere = $sSubSQLWhere;
	}

	/**
	 * get string format sub sql 'where'
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetStringSubSQLWhere()
	{
		return $this->sSubSQLWhere ;
	}
	
	

	
	//  For Sub SQL 'FROM'  ///////////////////////////////////////////
	/**
	 * set sub sql 'FROM'
	 *
	 * @access	public
	 * @param 	$aSubSQLFrom	JCAT_DBSubSQLFrom
	 * @return	void
	 */
	public function SetSubSQLFrom(JCAT_DBSubSQLFrom $aSubSQLFrom)
	{
		$this->aSubSQLFrom = $aSubSQLFrom ;
	}

	/**
	 * get sub sql 'FROM'
	 *
	 * @access	public
	 * @return	JCAT_DBSubSQLFrom
	 */
	public function GetSubSQLFrom()
	{
		return $this->aSubSQLFrom ;
	}

	/**
	 * set string format sub sql 'FROM'
	 *
	 * @access	public
	 * @param 	$sSubSQLFrom	string
	 * @return	void
	 */
	public function SetStringSubSQLFrom($sSubSQLFrom)
	{
		$this->sSubSQLFrom = $sSubSQLFrom;
	}

	/**
	 * get string format sub sql 'FROM'
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetStringSubSQLFrom()
	{
		return $this->sSubSQLFrom ;
	}


	

	
	//  For Sub SQL 'LIMIT'  ///////////////////////////////////////////
	/**
	 * set sub sql 'LIMIT'
	 *
	 * @access	public
	 * @param 	$aSubSQLLimit	JCAT_DBSubSQLLimit
	 * @return	void
	 */
	public function SetSubSQLLimit(JCAT_DBSubSQLLimit $aSubSQLLimit)
	{
		$this->aSubSQLLimit = $aSubSQLLimit ;
	}

	/**
	 * get sub sql 'LIMIT'
	 *
	 * @access	public
	 * @return	JCAT_DBSubSQLLimit
	 */
	public function GetSubSQLLimit()
	{
		return $this->aSubSQLLimit ;
	}

	/**
	 * set string format sub sql 'LIMIT'
	 *
	 * @access	public
	 * @param 	$sSubSQLLimit	string
	 * @return	void
	 */
	public function SetStringSubSQLLimit($sSubSQLLimit)
	{
		$this->sSubSQLLimit = $sSubSQLLimit;
	}

	/**
	 * get string format sub sql 'LIMIT'
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetStringSubSQLLimit()
	{
		return $this->sSubSQLLimit ;
	}
	

	
	//  For Sub SQL 'ORDER'  ///////////////////////////////////////////
	/**
	 * set sub sql 'ORDER'
	 *
	 * @access	public
	 * @param 	$aSubSQLOrder	JCAT_DBSubSQLOrder
	 * @return	void
	 */
	public function SetSubSQLOrder(JCAT_DBSubSQLOrder $aSubSQLOrder)
	{
		$this->aSubSQLOrder = $aSubSQLOrder ;
	}

	/**
	 * get sub sql 'ORDER'
	 *
	 * @access	public
	 * @return	JCAT_DBSubSQLOrder
	 */
	public function GetSubSQLOrder()
	{
		return $this->aSubSQLOrder ;
	}

	/**
	 * set string format sub sql 'ORDER'
	 *
	 * @access	public
	 * @param 	$sSubSQLOrder	string
	 * @return	void
	 */
	public function SetStringSubSQLOrder($sSubSQLOrder)
	{
		$this->sSubSQLOrder = $sSubSQLOrder;
	}

	/**
	 * get string format sub sql 'ORDER'
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetStringSubSQLOrder()
	{
		return $this->sSubSQLOrder ;
	}
	
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * Where 子句
	 * 
	 * @access	private
	 * @var		JCAT_DBSubSQLWhere
	 */
	protected $aSubSQLWhere = null ;
	protected $sSubSQLWhere = null ;

	/**
	 * From 子句
	 * 
	 * @access	private
	 * @var		JCAT_DBSubSQLFrom
	 */
	protected $aSubSQLFrom = null ;
	protected $sSubSQLFrom = null ;

	/**
	 * Limit 子句
	 * 
	 * @access	private
	 * @var		JCAT_DBSubSQLLimit
	 */
	protected $aSubSQLLimit = null ;
	protected $sSubSQLLimit = null ;

	/**
	 * Order 子句
	 * 
	 * @access	private
	 * @var		JCAT_DBSubSQLOrder
	 */
	protected $aSubSQLOrder = null ;
	protected $sSubSQLOrder = null ;



	/**
	 * “透明围栏” 内 的对象
	 * 
	 * @access	protected
	 * @var		array
	 */
	protected $arrObjectsInTransparent = array() ;


}
/*macro_exception_code:2*/
?>