<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBSQLSelect.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/



/**
 * SQL Select 子句
 *
 * @author		alee
 * @access		public
 */
class JCAT_DBSQLSelect extends JCAT_DBSQLRecordsOperate
{

	
	/**
	 * 数据表
	 * 
	 * @access	public
	 * @param	$aFactory		JCAT_DBAbstractFactory				对象工厂
	 * @param	$Tables			JCAT_DBGenericTypes::$TableList		数据表
	 * @return	
	 */
	public function JCAT_DBSQLSelect( JCAT_DBAbstractFactory $aFactory, $Tables=array() ) 
	{
		// 父类 构造函数
		$this->JCAT_DBSQLRecordsOperate($aFactory, $Tables) ;

		$this->aSubSQLGroup = $aFactory->CreateSubSQLGroup() ;
		$this->aSubSQLOn = $aFactory->CreateSubSQLOn() ;
		$this->aSubSQLReturnColumnList = $aFactory->CreateSubSQLReturnColumnList() ;

		// 透明围栏 内的对象
		$this->arrObjectsInTransparent[] = $this->aSubSQLGroup ;
		$this->arrObjectsInTransparent[] = $this->aSubSQLReturnColumnList ;
	}

	/**
	 * 创建并返回SQL语句
	 * 
	 * @access	public
	 * @return	string
	 */
	public function MakeSQL()
	{
		// SQL 子句
		$sSubSQLFrom = $this->MakeSubSQL('From') ;
		$sSubSQLWhere = $this->MakeSubSQL('Where') ;
		$sSubSQLOrder = $this->MakeSubSQL('Order') ;
		$sSubSQLLimit = $this->MakeSubSQL('Limit') ;
		$sSubSQLReturnColumnList = $this->MakeSubSQL('ReturnColumnList') ;
		$sSubSQLGroup = $this->MakeSubSQL('Group') ;
		$sSubSQLOn = $this->MakeSubSQL('On') ;
		
		return "SELECT {$sSubSQLReturnColumnList} FROM {$sSubSQLFrom} {$sSubSQLWhere} {$sSubSQLGroup} {$sSubSQLOn} {$sSubSQLOrder} {$sSubSQLLimit} ;" ;
	}



	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function __clone()
	{
		$this->aSubSQLGroup = clone $this->aSubSQLGroup ;
		$this->aSubSQLReturnColumnList = clone $this->aSubSQLReturnColumnList ;
		
		// 透明围栏 内的对象
		$this->arrObjectsInTransparent[] = $this->aSubSQLGroup ;
		$this->arrObjectsInTransparent[] = $this->aSubSQLReturnColumnList ;
		
		parent::__clone() ;
	}
	
	//  For Sub SQL 'GROUP'  ///////////////////////////////////////////
	/**
	 * set sub sql 'GROUP'
	 *
	 * @access	public
	 * @param 	$aSubSQLGroup	JCAT_DBSubSQLGroup
	 * @return	void
	 */
	public function SetSubSQLGroup(JCAT_DBSubSQLGroup $aSubSQLGroup)
	{
		$this->aSubSQLGroup = $aSubSQLGroup ;
	}

	/**
	 * get sub sql 'GROUP'
	 *
	 * @access	public
	 * @return	JCAT_DBSubSQLGroup
	 */
	public function GetSubSQLGroup()
	{
		return $this->aSubSQLGroup ;
	}

	/**
	 * set string format sub sql 'GROUP'
	 *
	 * @access	public
	 * @param 	$sSubSQLGroup	string
	 * @return	void
	 */
	public function SetStringSubSQLGroup($sSubSQLGroup)
	{
		$this->sSubSQLGroup = $sSubSQLGroup;
	}

	/**
	 * get string format sub sql 'GROUP'
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetStringSubSQLGroup()
	{
		return $this->sSubSQLGroup ;
	}

	

	
	//  For Sub SQL 'ON'  ///////////////////////////////////////////
	/**
	 * set sub sql 'ON'
	 *
	 * @access	public
	 * @param 	$aSubSQLOn	JCAT_DBSubSQLOn
	 * @return	void
	 */
	public function SetSubSQLOn(JCAT_DBSubSQLOn $aSubSQLOn)
	{
		$this->aSubSQLOn = $aSubSQLOn ;
	}

	/**
	 * get sub sql 'ON'
	 *
	 * @access	public
	 * @return	JCAT_DBSubSQLOn
	 */
	public function GetSubSQLOn()
	{
		return $this->aSubSQLOn ;
	}

	/**
	 * set string format sub sql 'ON'
	 *
	 * @access	public
	 * @param 	$sSubSQLOn	string
	 * @return	void
	 */
	public function SetStringSubSQLOn($sSubSQLOn)
	{
		$this->sSubSQLOn = $sSubSQLOn;
	}

	/**
	 * get string format sub sql 'ON'
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetStringSubSQLOn()
	{
		return $this->sSubSQLOn ;
	}

	
	
	//  For Sub SQL 'Return Column List'  ///////////////////////////////////////////
	/**
	 * set sub sql 'Return Column List'
	 *
	 * @access	public
	 * @param 	$aSubSQLReturnColumnList	JCAT_DBSubSQLReturnColumnList
	 * @return	void
	 */
	public function SetSubSQLReturnColumnList(JCAT_DBSubSQLReturnColumnList $aSubSQLReturnColumnList)
	{
		$this->aSubSQLReturnColumnList = $aSubSQLReturnColumnList ;
	}

	/**
	 * get sub sql 'Return Column List'
	 *
	 * @access	public
	 * @return	JCAT_DBSubSQLReturnColumnList
	 */
	public function GetSubSQLReturnColumnList()
	{
		return $this->aSubSQLReturnColumnList ;
	}

	/**
	 * set string format sub sql 'Return Column List'
	 *
	 * @access	public
	 * @param 	$sSubSQLReturnColumnList	string
	 * @return	void
	 */
	public function SetStringSubSQLReturnColumnList($sSubSQLReturnColumnList)
	{
		$this->sSubSQLReturnColumnList = $sSubSQLReturnColumnList;
	}

	/**
	 * get string format sub sql 'Return Column List'
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetStringSubSQLReturnColumnList()
	{
		return $this->sSubSQLReturnColumnList ;
	}
	
	

	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * SubSQL Group 子句
	 * 
	 * @access	private
	 * @var		JCAT_DBSubSQLGroup
	 */
	private $aSubSQLGroup = null ;
	
	/**
	 * SubSQL Group 子句
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sSubSQLGroup = null ;

	/**
	 * SubSQL ReturnColumnList 子句
	 * 
	 * @access	private
	 * @var		JCAT_DBSubSQLReturnColumnList
	 */
	private $aSubSQLReturnColumnList = null ;

	/**
	 * SubSQL ReturnColumnList 子句
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sSubSQLReturnColumnList = null ;

	/**
	 * SubSQL On 子句
	 * 
	 * @access	private
	 * @var		JCAT_DBSubSQLOn
	 */
	private $aSubSQLOn = null ;

	/**
	 * SubSQL On 子句
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sSubSQLOn = null ;


}
?>