<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBReflectorMySQL.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/



class JCAT_DBReflectorMySQL implements JCAT_IDBReflector
{
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aDBConn		JCAT_DBConnect
	 * @return	void
	 */
	public function __construct(JCAT_DBConnect $aDBConn)
	{
		$this->aDBConn = $aDBConn ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sDBName		string
	 * @return	array
	 */
	public function QueryDatabases($bRequery=false)
	{
		if( empty($this->arrDBNames) or $bRequery )
		{
			// 执行
			$hResult = $this->aDBConn->Query("SHOW DATABASES ;") ;
			
			// 失败
			if($hResult===false)
			{
				$this->aDBConn->ExecuteFail(JCAT_Language::SentenceEx('无法取得数据库名称清单。','JCAT',null)) ;
				return false ;
			}
			
			while( $arrRes=mysql_fetch_row($hResult) )
			{
				$this->arrDBNames[] = $arrRes[0] ;
			}
		}
		
		return $this->arrDBNames ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function QueryTables($sDBName=null,$bRequery=false)
	{
		// 确定数据库
		$sDBName = ($sDBName===null)?
						$this->aDBConn->GetCurrentDB(): $sDBName ;
		JCAT_ASSERT::ASSERT_STRING($sDBName) ;
							
		if( empty($this->arrDBTables[$sDBName]) or $bRequery )
		{
			// 执行
			$hResult = $this->Query("SHOW TABLES ;",$sDBName) ;
			
			// 失败
			if($hResult===false)
			{
				$this->aDBConn->ExecuteFail(JCAT_Language::SentenceEx('无法取得数据表名称清单。','JCAT',null)) ;
				return false ;
			}
			
			while( $arrRes=mysql_fetch_row($hResult) )
			{
				$this->arrDBTables[$sDBName][ $arrRes[0] ] = array(
						'name' => $arrRes[0] ,
				) ;
			}
		}

		return array_keys($this->arrDBTables[$sDBName]) ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sTableName		string		What's this Parameter ?
	 * @param	$sDBName＝null	string		What's this Parameter ?
 * @return	void
	 */
	public function QueryColumns($sTableName,$sDBName=null,$bRequery=false)
	{
		JCAT_ASSERT::ASSERT_($this->aDBConn->IsConnected(),JCAT_Language::SentenceEx('数据库尚未连接。','JCAT',null)) ;
		
		// 确定数据库
		$sDBName = ($sDBName===null)?
						$this->aDBConn->GetCurrentDB(): $sDBName ;
		JCAT_ASSERT::ASSERT_STRING($sTableName) ;
		JCAT_ASSERT::ASSERT_STRING($sDBName) ;
						
		if( empty($this->arrDBColumns[$sDBName][$sTableName]) or $bRequery )
		{
			// 执行
			$hResult = mysql_list_fields($sDBName,$sTableName,$this->aDBConn->GetConnectHandle()) ;
			
			// 失败
			if($hResult===false)
			{
				$this->aDBConn->ExecuteFail(JCAT_Language::SentenceEx('无法取得数据表 %s.%s 的字段清单。','JCAT',null,$sDBName,$sTableName)) ;
				return false ;
			}

			$nFieldNum = mysql_num_fields($hResult) ;
			for ($nIdx=0;$nIdx<$nFieldNum;$nIdx++)
			{
				$aClmInfo = new JCAT_DBColumnInfoMySQL($sDBName, $sTableName, $hResult, $nIdx) ;
				$this->arrDBColumns[$sDBName][$sTableName][$aClmInfo->GetColumnName()] = $aClmInfo ;
			}
		}
		
		return array_keys($this->arrDBColumns[$sDBName][$sTableName]) ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sColumn				string
	 * @param	$sTable				string
	 * @param	$sDBName=null		string
	 * @return	JCAT_IDBColumnInfo
	 */
	public function GetColumnInfo($sColumn,$sTable,$sDBName=null,$bRequery=false)
	{
		// 确定数据库
		$sDBName = ($sDBName===null)?
						$this->aDBConn->GetCurrentDB(): $sDBName ;
		JCAT_ASSERT::ASSERT_STRING($sTable) ;
		JCAT_ASSERT::ASSERT_STRING($sDBName) ;
		JCAT_ASSERT::ASSERT_STRING($sColumn) ;
		
		if( empty($this->arrDBColumns[$sDBName][$sTable][$sColumn]) or $bRequery )
		{
			$this->QueryColumns($sTable,$sDBName) ;
		}

		return $this->arrDBColumns[$sDBName][$sTable][$sColumn] ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function GetPrimaryKey($sTable,$sDBName=null,$bRequery=false)
	{
		// 确定数据库
		$sDBName = ($sDBName===null)?
						$this->aDBConn->GetCurrentDB(): $sDBName ;
		JCAT_ASSERT::ASSERT_STRING($sTable) ;
		JCAT_ASSERT::ASSERT_STRING($sDBName) ;

		if( !isset($this->arrDBTables[$sDBName][$sTable]) or $bRequery )
		{
			$this->arrDBTables[$sDBName][$sTable]['primaryKey'] = '@no primary key@' ;
			
			$arrClmNames = $this->QueryColumns($sTable,$sDBName,$bRequery) ;
			foreach ($arrClmNames as $sClmName)
			{
				$aClmInfo = $this->GetColumnInfo($sClmName,$sTable,$sDBName) ;
				
				if( $aClmInfo->IsPrimary() )
				{
					$this->arrDBTables[$sDBName][$sTable]['primaryKey'] = $sClmName ;
					break ;
				}
			}
		}
		
		return ($this->arrDBTables[$sDBName][$sTable]['primaryKey']=='@no primary key@')?
						null: $this->arrDBTables[$sDBName][$sTable]['primaryKey'] ;
	}
	
	/**
	 * 查询当前连接中，是否存在一个数据库
	 * 
	 * @access	public
	 * @param	$sDBName	string	数据库 库名
	 * @return	bool
	 */
	public function IsDatabaseExists(  $sDBName )
	{}

	

	/**
	 * 查询一个数据表是否存在
	 * 
	 * @access	public
	 * @param	$sTableName		string	数据表
	 * @param	$sDBName=null	string	数据库，如果为null 则使用 SelectDB() 设定的值
	 * @return	bool
	 */
	public function IsTableExists( $sTableName, $sDBName=null )
	{}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_DBConnect
	 */
	private $aDBConn ;
	
	
	/**
	 * cache db names
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrDBNames = array() ;
	
	/**
	 * cache table names
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrDBTables = array() ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrDBColumns = array() ;
	
}

?>