<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: interface.JCAT_IDBReflector.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/



interface JCAT_IDBReflector
{
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sDBName		string
	 * @return	array
	 */
	public function QueryDatabases($bRequery=false) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function QueryTables($sDBName=null,$bRequery=false) ;

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sTableName		string		What's this Parameter ?
	 * @param	$sDBName＝null	string		What's this Parameter ?
 	 * @return	void
	 */
	public function QueryColumns($sTableName,$sDBName=null,$bRequery=false) ;

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sColumn				string
	 * @param	$sTable				string
	 * @param	$sDBName=null		string
	 * @return	JCAT_IDBColumnInfo
	 */
	public function GetColumnInfo($sColumn,$sTable,$sDBName=null,$bRequery=false) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function GetPrimaryKey($sTable,$sDBName=null,$bRequery=false) ;
	
	/**
	 * 查询当前连接中，是否存在一个数据库
	 * 
	 * @access	public
	 * @param	$sDBName	string	数据库 库名
	 * @return	bool
	 */
	public function IsDatabaseExists(  $sDBName ) ;

	

	/**
	 * 查询一个数据表是否存在
	 * 
	 * @access	public
	 * @param	$sTableName		string	数据表
	 * @param	$sDBName=null	string	数据库，如果为null 则使用 SelectDB() 设定的值
	 * @return	bool
	 */
	public function IsTableExists( $sTableName, $sDBName=null ) ;
	
}

?>