<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBException.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




abstract class JCAT_DBException extends JCAT_Exception
{

	/**
	 * JCAT_DB 异常
	 * 
	 * @access	public
	 * @param	$sMsg=''		string	异常消息
	 * @param	$nCode			int		JCAT统一异常ID，是一个2进制24位整数，左八位代表包ID，左16位代表Class ID，右8位代表异常ID
	 * @param	$sDBSQL=''		string	正在执行的 SQL 语句
	 * @param	$nDBCode=0	int		数据库返回的 错误 Code
	 * @param	$sDBMsg=''		string	数据库返回的 错误讯息
	 * @return	void
	 */
	public function JCAT_DBException( $sMsg='', $nCode=0, $sDBSQL='', $nDBCode=0, $sDBMsg='' ) 
	{
		$this->SetDefaultProcessor(
			new JCAT_ExceptionProcessorHtml($this,'template.JCAT_ExceptionProcessorHtmlDBView.html')
		) ;
		
		$this->JCAT_Exception($sMsg,$nCode) ;
		
		$this->sDBSQL = $sDBSQL ;
		$this->nDBCode = $nDBCode ;
		$this->sDBMsg = $sDBMsg ;
	}

	public function GetDBCode()
	{ return $this->nDBCode ; }
	
	public function GetDBMsg()
	{ return $this->sDBMsg ;}
	
	public function GetDBSQL()
	{ return $this->sDBSQL ; }
	
	/**
	 * 返回异常是否由重复输入引起
	 *
	 * @access	public
	 * @return	bool
	 */
	abstract public function IsDuplicateData() ;
	
	
	private $sDBSQL ;
	private $nDBCode ;
	private $sDBMsg ;
}
?>