<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_DBGenericTypes.php 1633 2009-04-07 09:04:08Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * DB包的 泛型支持， 负责检查类型，并转换为统一类型
 *
 * @author		alee
 * @access		public
 */
class JCAT_DBGenericTypes
{

	// 泛型定义 /////////////////////////////////////////////
	
	// 字段
	static private $Column = array(
					'string',
					'JCAT_DBColumn'
	) ;
	
	// 字段清单
	static private $ColumnList = array(
					'string',
					'JCAT_DBColumn',
					'array:string,JCAT_DBColumn'
	) ;
	
	
	// 返回字段类型
	static private $ReturnColumn = array(
					'string',
					'JCAT_DBReturnColumn',
					'JCAT_DBFunctionCall'
	) ;
	
	
	// 返回字段清单类型
	static private $ReturnColumnList = array(
					'string',
					'JCAT_DBReturnColumn',
					'JCAT_DBFunctionCall',
					'JCAT_DBSubSQLReturnColumnList',
					'array:string,JCAT_DBReturnColumn,JCAT_DBFunctionCall',
	) ;
	

	// 数据表
	static private $Table = array(
					'string',
					'JCAT_DBTable',
					'JCAT_DBTableJoin',
					'JCAT_DBSQLSelect',
	) ;
	

	// 数据表 清单
	static private $TableList = array(
					'string',
					'JCAT_DBTable',
					'JCAT_DBTableJoin',
					'array:string,JCAT_DBTable,JCAT_DBTableJoin',
					'JCAT_DBSubSQLFrom',
	) ;
	

	// SQL语句
	static public $SQL = array(
					'string',
					'JCAT_DBSQL',
	) ;

	

	// 条件子句中的 运算对象
	static public $ConditionObject = array(
					'base',
					'JCAT_DBColumn',
					'JCAT_DBFunctionCall',
					'JCAT_DBTableSelectResult',
					'JCAT_DBExpression',
	) ;

	// 值
	static public $Value = array(
					'base',
					'JCAT_DBObject',
	) ;




	/**
	 * 将泛型 GENERIC_DBColumn 转换成可用的 JCAT_DBColumn 对象
	 * 
	 * @access	public
	 * @param	$aFactory	 JCAT_DBAbstractFactory 对象工厂，用于创建  JCAT_DBColumn 对象
	 * @param	$Variable	 self::$Column 			泛型变量
	 * @static
	 * @return	JCAT_DBColumn
	 */
	static public function TransColumn( JCAT_DBAbstractFactory $aFactory, $Variable ) 
	{
		JCAT_ASSERT::ASSERT_ISTHESE($Variable,self::$Column,JCAT_Language::SentenceEx('参数 $Variable 必须为 JCAT_DBGenericTypes::$Column 类型','JCAT',null)) ;
		
		if( is_string($Variable) ) 
		{
			return $aFactory->CreateColumn($Variable) ;
		}
		else if( JCAT_Global::IsKindOf($Variable,'JCAT_DBColumn') )
		{
			return $Variable ;
		}
		else
		{
			JCAT_ASSERT::ASSERT_(false,'?! Why?') ;
		}
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @static
	 * @return	
	 */
	static public function TransColumnList(  ) 
	{
		// Todo Samething ... ...
		// ... ...
	}


	/**
	 * 将泛型 GENERIC_DBReturnColumn 转换成可用的 类型
	 * 
	 * @access	public
	 * @param	$aFactory	 				JCAT_DBAbstractFactory 	对象工厂，用于创建  JCAT_DBReturnColumn 对象
	 * @param	$Variable					self::$ReturnColumn		泛型变量
	 * @param	$sFullNameAlias=false		bool 						返回 完整名称（table.column）
	 * @static
	 * @return	JCAT_DBReturnColumn,JCAT_DBFunctionCall
	 */
	static public function TransReturnColumn( JCAT_DBAbstractFactory $aFactory, $Variable, $sFullNameAlias=false ) 
	{
		//JCAT_ASSERT::ASSERT_INSTANCE($aFactory,'GENERIC_DBReturnColumn') ;
		JCAT_ASSERT::ASSERT_ISTHESE($Variable,self::$ReturnColumn,JCAT_Language::SentenceEx('参数 $Variable 必须为 JCAT_DBGenericTypes::$ReturnColumn 类型','JCAT',null)) ;

		if( is_string($Variable) )
		{
			$aReturnClm = $aFactory->CreateReturnColumn($Variable) ;
			if( $sFullNameAlias and !$aReturnClm->GetAlias() )
			{
				$aReturnClm->UseFullNameAlias() ;
			}
			return $aReturnClm ;
		}
		else if( JCAT_Global::IsThese($Variable,array('JCAT_DBReturnColumn','JCAT_DBFunctionCall')) )
		{
			return $Variable ;
		}
		else
		{
			JCAT_ASSERT::ASSERT_(false,'!?') ;
		}
	}



	/**
	 * 将泛型 self::$ReturnColumnList 转换成 可用的类型
	 * 
	 * @access	public
	 * @param	$aFactory	 			JCAT_DBAbstractFactory 	对象工厂，用于创建  JCAT_DBColumn 对象
	 * @param	$Variable				self::$Table 				泛型变量
	 * @param	$sFullNameAlias=false	bool 						返回 完整名称（table.column）
	 * @static
	 * @return	JCAT_DBSubSQLReturnColumnList
	 */
	static public function TransReturnColumnList( $aFactory, $Variable, $sFullNameAlias=false )
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aFactory,'JCAT_DBAbstractFactory') ;
		JCAT_ASSERT::ASSERT_ISTHESE($Variable,self::$ReturnColumnList,JCAT_Language::SentenceEx('参数 $Variable 必须为 JCAT_DBGenericTypes::$ReturnColumnList 类型','JCAT',null)) ;
		
		if( JCAT_Global::IsKindOf($Variable,'JCAT_DBSubSQLReturnColumnList') )
		{
			return $Variable ;
		}
		else
		{
			$aSubSQLReturnColumnList = $aFactory->CreateSubSQLReturnColumnList() ;
			
			if($Variable!=='*')			// 对于 '*' 只需返回 空的  JCAT_DBSubSQLReturnColumnList 对象即可
			{
				if( !is_array($Variable) )
				{
					$Variable = array($Variable) ;
				}
				
				foreach($Variable as $Item)
				{
					$aSubSQLReturnColumnList->AddReturnColumn(self::TransReturnColumn($aFactory,$Item,$sFullNameAlias)) ;
				}
			}
			
			return $aSubSQLReturnColumnList ;
		}
	}
	
	
	/**
	 * 将泛型 GENERIC_DBTable 转换成可用的 JCAT_DBTable 对象
	 * 
	 * @access	public
	 * @param	$aFactory	 JCAT_DBAbstractFactory 对象工厂，用于创建  JCAT_DBColumn 对象
	 * @param	$Variable	 self::$Table 			泛型变量
	 * @static
	 * @return	JCAT_DBTable,JCAT_DBTableJoin
	 */
	static public function TransTable( JCAT_DBAbstractFactory $aFactory, $Variable ) 
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aFactory,'JCAT_DBAbstractFactory') ;
		JCAT_ASSERT::ASSERT_ISTHESE($Variable,self::$Table,JCAT_Language::SentenceEx('参数 $Variable 必须为 JCAT_DBGenericTypes::$Table 类型','JCAT',null)) ;
		
		if( is_string($Variable) )
		{
			return $aFactory->CreateTable($Variable) ;
		}
		else if( JCAT_Global::IsThese($Variable,array('JCAT_DBTable','JCAT_DBTableJoin','JCAT_DBSQLSelect')) )
		{
			return $Variable ;
		}
		else
		{
			JCAT_ASSERT::ASSERT_(false,'?! Why?') ;
		}
	}

	/**
	 * 
	 * 
	 * @access	public
	 * @param	$aFactory	 JCAT_DBAbstractFactory 对象工厂，用于创建  JCAT_DBColumn 对象
	 * @param	$Variable	 self::$TableList		泛型变量
	 * @static
	 * @return	JCAT_DBSubSQLFrom
	 */
	static public function TransTableList( JCAT_DBAbstractFactory $aFactory, $Variable ) 
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aFactory,'JCAT_DBAbstractFactory') ;
		JCAT_ASSERT::ASSERT_ISTHESE($Variable,JCAT_DBGenericTypes::$TableList,JCAT_Language::SentenceEx('参数 $Variable 必须为 JCAT_DBGenericTypes::$TableList 类型','JCAT',null)) ;
		
		if( JCAT_Global::IsKindOf($Variable,'JCAT_DBSubSQLFrom') )
		{
			return $Variable ;
		}

		if( !is_array($Variable) )
		{
			$arrTables = array( $Variable );
		}
		else
		{
			$arrTables = $Variable ;
		}
		
		$aSubSQLFrom = $aFactory->CreateSubSQLFrom() ;
		foreach($arrTables as $Table)
		{
			$aSubSQLFrom->AddTable( self::TransTable($aFactory,$Table) ) ;
		}
		
		return $aSubSQLFrom ;
	}



	/**
	 * 将泛型 self::$SQL 转换成可用的string格式
	 * 
	 * @access	public
	 * @param	$Variable	self::$SQL 泛型变量
	 * @static
	 * @return	string
	 */
	static public function TransSQL( $Variable ) 
	{
		JCAT_ASSERT::ASSERT_ISTHESE($Variable,self::$SQL,JCAT_Language::SentenceEx('参数 $Variable 必须为 JCAT_DBGenericTypes::$SQL 类型','JCAT',null)) ;
		
		if( is_string($Variable) )
		{
			return $Variable ;
		}
		else if( JCAT_Global::IsKindOf($Variable,'JCAT_DBSQL') )
		{
			return $Variable->MakeSQL() ;
		}
		else
			JCAT_ASSERT::ASSERT_(false,'?! Why?') ;
	}

	/**
	 * 将泛型 self::$ConditionObject 转换成可用的string格式
	 * 
	 * @access	public
	 * @param	$Variable	self::$ConditionObject 泛型变量
	 * @static
	 * @return	
	 */
	static public function TransConditionObject( $Variable ) 
	{
		JCAT_ASSERT::ASSERT_ISTHESE($Variable,self::$ConditionObject,JCAT_Language::SentenceEx('参数 $Variable 必须为 JCAT_DBGenericTypes::$ConditionObject 类型','JCAT',null)) ;
		
		if( JCAT_Global::IsA($Variable,'base') )
		{
			return self::TransValue($Variable) ;
		}
			
		else if( JCAT_Global::IsThese($Variable,array('JCAT_DBColumn','JCAT_DBFunctionCall','JCAT_DBSQLSelect','JCAT_DBExpression')) )
		{
			return $Variable ;
		}
			
		else
		{
			JCAT_ASSERT::ASSERT_(false,'?! Why?') ;
		}
	}


	/**
	 * 将php的基础类型 转换成 SQL
	 * 
	 * @access	public
	 * @param	$Variable	base PHP变量
	 * @static
	 * @return	string
	 */
	static function TransValue($Variable)
	{
		JCAT_ASSERT::ASSERT_ISTHESE($Variable,self::$Value) ;
		
		if( is_int($Variable) or is_float($Variable) )	
		{
			return "{$Variable}" ;
		}
		else if( is_bool($Variable) )
		{
			return $Variable? "'1'": "'0'" ;
		}
		else if( is_string($Variable) )
		{
			return "'".addslashes($Variable)."'" ;
		}
		else if( JCAT_Global::IsKindOf($Variable,'JCAT_DBObject') )
		{
			return $Variable->MakeSQL() ;
		}
		else
		{
			JCAT_ASSERT::ASSERT_(0,'?!') ;
		}
	}

}
?>