<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_LinkedList.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 链表， 目前只是 为 队列 和 栈提供基类
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_LinkedList
{


	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$sType1...	string	可用类型
	 * @return	void
	 */
	public function JCAT_LinkedList() 
	{ $thsi->arrTypes = func_get_args() ;}



	/**
	 * 加入
	 * 
	 * @access	public
	 * @param	$Item	mixed	元素
	 * @return	void
	 */
	abstract public function In( $Item )  ;



	/**
	 * 取出
	 * 
	 * @access	public
	 * @return	mixed
	 */
	abstract public function Out()  ;


	public function Remove($nIdx)
	{
		unset($this->arrItems[$nIdx]) ;
	}
	

	/**
	 * 返回当前链表中元素的数量
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetLength() 
	{ return count($this->arrItems) ; }


	/**
	 * 链表是否为空
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function IsEmpty() 
	{ return ($this->GetLength()==0) ; }



	/**
	 * 检查 是否 符合 链表对类型的限制
	 * 
	 * @access	public
	 * @param	$Item	mixed	待检测的 元素
	 * @return	bool
	 */
	public function IsValidType( $Item ) 
	{
		if( !count($this->arrTypes) )
			return true ;
		
		return call_user_func_array( array('JCAT_Global','IsThese'), array($Item,$this->arrTypes) ) ;
	}


	public function CreateIterator()
	{
				return new JCAT_ArrayIterator($this->arrItems) ;
	}


	public function CreateReverseIterator()
	{
				return new JCAT_ArrayReverseIterator($this->arrItems) ;
	}


	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 链表中的元素
	 * 
	 * @access	private
	 * @var		array
	 */
	protected $arrItems = array() ;

	/**
	 * 允许的类型
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrTypes = array() ;


}
?>