<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_Map.php 1999 2009-08-20 13:50:51Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/



/**
 * 映射
 *
 * @author		alee
 * @access		public
 */
class JCAT_Map
{
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$bStrictly=true		bool	严格模式
	 * @return	void
	 */
	public function JCAT_Map($bStrictly=true)
	{
		$this->bStrictly = $bStrictly ;
	}
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$Source						mixed	源变量
	 * @param	$Mapping					mixed	映射变量
	 * @param	$sMappingName='default'		string	映射名称
	 * @return	old_value
	 */
	public function Set( $Source, $Mapping, $sMappingName='default' )
	{
		JCAT_ASSERT::ASSERT_STRING($sMappingName) ;
		
		$nIdx = $this->_FindSource($Source) ;
		JCAT_ASSERT::ASSERT_INT($nIdx);

		if($nIdx<0)
		{
			$this->arrMappings[] = array(
				'source' => $Source ,
				'mappings' => array($sMappingName=>$Mapping)
			) ;
			return null ;
		}
		
		else
		{
			$old_value = isset($this->arrMappings[$nIdx]['mappings'][$sMappingName])?
							$this->arrMappings[$nIdx]['mappings'][$sMappingName]: null ;
			$this->arrMappings[$nIdx]['mappings'][$sMappingName] = $Mapping ;
			return $old_value ;
		}
			
	}
	
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$Source						mixed	源变量
	 * @param	$sMappingName='default'		string	映射名称
	 * @return	mixed
	 */
	public function Get( $Source, $sMappingName='default' )
	{
		JCAT_ASSERT::ASSERT_STRING($sMappingName) ;
		
		$nIdx = $this->_FindSource($Source) ;
		JCAT_ASSERT::ASSERT_INT($nIdx);
		
		if($nIdx<0)
		{
			return null ;
		}
		
		else
		{
			return isset($this->arrMappings[$nIdx]['mappings'][$sMappingName])?
							$this->arrMappings[$nIdx]['mappings'][$sMappingName]: null ;			
		}
		
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Source						mixed	源变量
	 * @return	void
	 */
	public function Clear($Source)
	{
		$nIdx = $this->_FindSource($Source) ;
		unset($this->arrMappings[$nIdx]) ;
	}
	
	
	/**
	 * what's this
	 * 
	 * @access	private
	 * @param	$Source		mixed	源变量
	 * @return	int
	 */
	private function _FindSource($Source)
	{
		foreach( $this->arrMappings as $nIdx=>$arrMapping )
		{
			if( ($this->bStrictly and $arrMapping['source']===$Source )
				or
				(!$this->bStrictly and $arrMapping['source']==$Source) )
			{
				return $nIdx ;
			}
		}
		
		return -1 ;
	}
	// 属性 //////////////////////////////////
	
	/**
	 * 映射对
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrMappings = array() ;
	
	/**
	 * 严格模式
	 * 
	 * @access	private
	 * @var		array
	 */
	private $bStrictly = true ;
}

?>