<?php
// Call JCAT_FSOTreeIteratorTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_FSOTreeIteratorTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/桌面/lib.php/Common/FileSystem/class.JCAT_FSOTreeIterator.php';

/**
 * Test class for JCAT_FSOTreeIterator.
 * Generated by PHPUnit on 2007-12-27 at 15:18:37.
 */
class JCAT_FSOTreeIteratorTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_FSOTreeIteratorTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testFirst().
     */
    public function testDethFirst() {
        
		$nFlag = JCAT_FSOIterator::DIR|JCAT_FSOIterator::FILE|JCAT_FSOIterator::RETURN_PATH ;
		$aIterator = new JCAT_FSOTreeIterator(dirname(__FILE__).'/TestTop',$nFlag) ;
		
		echo  "非深度优先......\r\n" ;
		$nCount = 0 ;
		while( !$aIterator->IsDone() )
		{
			$nCount ++ ;
			echo $aIterator->Current()."\r\n" ;
			$aIterator->Next() ;
		}
		
		echo $nCount."\r\n" ;
		
		
		echo  "再来一遍......\r\n" ;
		$aIterator->First() ;
		$nCount = 0 ;
		while( !$aIterator->IsDone() )
		{
			$nCount ++ ;
			echo $aIterator->Current()."\r\n" ;
			$aIterator->Next() ;
		}
		
		echo $nCount."\r\n" ;
		
    }

    /**
     * @todo Implement testCurrent().
     */
    public function testNotDethFirst() {
        
		$nFlag = JCAT_FSOIterator::DIR|JCAT_FSOIterator::FILE|JCAT_FSOIterator::RETURN_PATH ;
		$aIterator = new JCAT_FSOTreeIterator(dirname(__FILE__).'/TestTop',$nFlag,true) ;
		
		echo  "\r\n\r\n深度优先......\r\n" ;
		$nCount = 0 ;
		while( !$aIterator->IsDone() )
		{
			$nCount ++ ;
			echo $aIterator->Current()."\r\n" ;
			$aIterator->Next() ;
		}
		
		echo $nCount."\r\n" ;
		
		
		
		echo  "再来一遍......\r\n" ;
		$aIterator->First() ;
		$nCount = 0 ;
		while( !$aIterator->IsDone() )
		{
			$nCount ++ ;
			echo $aIterator->Current()."\r\n" ;
			$aIterator->Next() ;
		}
		
		echo $nCount."\r\n" ;
    }
}

// Call JCAT_FSOTreeIteratorTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_FSOTreeIteratorTest::main')
	JCAT_FSOTreeIteratorTest::main();
?>
