<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_Directory.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 目录
 *
 * @author		alee
 * @access		public
 */
class JCAT_Directory extends JCAT_FSO
{

	function JCAT_Directory($sPath)
	{
		if( !is_dir($sPath) )
		{
			throw new JCAT_Exception( JCAT_Language::SentenceEx('参数 $sPath 不是一个有效的目录','JCAT',null), __macro_exception_code__ ) ;
		}

		$this->sPath = JCAT_Global::TidyPath($sPath) ;
		$this->bFile = false ;
	}
	

	/**
	 * 返回文件長度，或 目录下 所有文件長度
	 * 
	 * @access	public
	 * @param	$nUnit=1024		int		单位
	 * @param	$bTotal=true	bool	包括所有下级
	 * @return	float,int
	 */
	public function GetByte( $nUnit=1024, $bTotal=true )
	{
	}

	/**
	 * 为当前目录创建一个迭代器
	 * 
	 * @access	public
	 * @param	$bTree=true										bool	迭代子目录
	 * @param	$bDepthFirst=false								bool	如果迭代子目录，则以深度优先的方式进行
	 * @param	$nIteratorFlag=JCAT_FSOIterator::DEFAULT_FLAG	int		迭代方式
	 */
	public function CreateIterator( $bTree=true, $bDepthFirst=false, $nIteratorFlag=JCAT_FSOIterator::DEFAULT_FLAG )
	{
		if($bTree)
		{
			return new JCAT_FSOTreeIterator($this->sPath,$nIteratorFlag,$bDepthFirst) ;
		}
		else
		{
			return new JCAT_FSOIterator($this->sPath,$nIteratorFlag) ;
		}
	}

}
?>