<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_FSO.php 1911 2009-06-21 06:49:36Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 文件系统对象，JCAT_File 和 JCAT_Directory 的基类
 *
 * @author		alee
 * @access		public
 */
abstract class JCAT_FSO
{


	/**
	 * 根据 路径，返回一个 FSO 对象。如果路径是一个 文件，则返回 JCAT_File， 如果路径是 目录，返回 JCAT_Directory， 如果不存在，返回 null
	 * 
	 * @access	public
	 * @param	$sPath	string	路径
	 * @static
	 * @return	JCAT_FSO
	 */
	static public function Instance( $sPath ) 
	{
		if( !file_exists($sPath) )
			return null ;
		if( is_file($sPath) )
		{
			return new JCAT_File($sPath) ;
		}
		else
		{
			return new JCAT_Directory($sPath) ;
		}
	}



	/**
	 * 获得名称
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetName() 
	{ return basename($this->sPath) ; }



	/**
	 * 返回上级目录
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetParentDirectory(  ) 
	{ return dirname($this->sPath).'/' ; }



	/**
	 * 返回目录
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetPath() 
	{ return $this->sPath ; }



	/**
	 * 返回文件長度，或 目录下 所有文件長度
	 * 
	 * @access	public
	 * @param	$nUnit=1024		int 单位
	 * @return	float,int
	 */
	abstract public function GetByte( $nUnit=1024 ) ;



	/**
	 * 是否是文件
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function IsFile(  ) 
	{ return $this->bFile ; }


	/**
	 * 是否是链接
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function IsLink() 
	{ return is_link($this->sPath) ; }



	/**
	 * 是否是 . 或 ..
	 * 
	 * @access	public
	 * @return	
	 */
	public function IsDot(  ) 
	{ return in_array( $this->GetName(), array('.','..') ) ; }


	
	/**
	 * 删除目录
	 * 
	 * @access	public
	 * @param	$sDir					string		目标目录
	 * @param	$bRecursive=false		bool		递归删除
	 * @param	$bGiveUp4Error=false	bool		遇到错误 放弃任务
	 * @param	$bIgnoreLnk=true		bool		忽略链接
	 * @return	bool
	 * @static
	 */
	static public function DeleteDir($sDir,$bRecursive=false,$bGiveUp4Error=false,$bIgnoreLnk=true)
	{
		JCAT_ASSERT::ASSERT_STRING($sDir) ;
		JCAT_ASSERT::ASSERT_BOOL($bRecursive) ;
		JCAT_ASSERT::ASSERT_BOOL($bGiveUp4Error) ;
		
		if( !file_exists($sDir) )
			return true ;
		
		JCAT_ASSERT::ASSERT_DIR($sDir) ;
		
		// 常规 方式
		if(!$bRecursive)
		{
			return rmdir($sDir) ;
		}
		
		// 递归删除
		else
		{
			$bRemains = false ;
			
			// 迭代 目录
			$aIterator = new JCAT_FSOIterator($sDir,JCAT_FSOIterator::DIR|JCAT_FSOIterator::FILE|JCAT_FSOIterator::RETURN_FSO) ;
			$aIterator->First() ;
			while( !$aIterator->IsDone() )
			{
				$aFSO = $aIterator->Current() ;
				
				// 删除 文件
				if( $aFSO->IsFile() )
				{
					if( !unlink( $aFSO->GetPath() ) )
					{
						$bRemains = true ;
					}
				}
				// 递归处理 下级目录
				else
				{
					// 目录链接，仅仅删除（不进入递归）
					if ($bIgnoreLnk and $aFSO->IsLink())
					{
						if( !unlink( $aFSO->GetPath() ) )
						{
							$bRemains = true ;
						}
					}
					
					else 
					{
						if( !self::DeleteDir($aFSO->GetPath(),$bRecursive,$bGiveUp4Error) )
						{
							$bRemains = true ;
						}
					}
				}
				
				$aIterator->Next() ;
			}
			

			// 完成
			return $bRemains?
						false :				// 文件 和 下级目录 残留
						rmdir($sDir) ;		// 文件 和 下级目录 已清理干净
		}
	}

	/**
	 * 复制目录（可递归）
	 *
	 * @access	public
	 * @param	$sSourcePath
	 * @param	$sTargetPath
	 * @static
	 * @return	bool
	 */
	static public function CopyDir($sSourcePath,$sTargetPath,$arrFilter=array(''))
	{
		if( !is_dir($sSourcePath) )
		{
			print JCAT_Language::SentenceEx('源路径不是一个目录：“%s”','JCAT',null,$sSourcePath)  ;
			return false ;
		}
		if( file_exists($sTargetPath) )
		{
			print JCAT_Language::SentenceEx('目标路径已经存在，无法完成拷贝：“%s”','JCAT',null,$sTargetPath)  ;
			return false ;
		}
		
		// 创建目标目录
		mkdir($sTargetPath,0777,true) ;
		
		// 创建迭代器
		$aIterator = new JCAT_FSOIterator($sSourcePath) ;
		$aIterator->First() ;
		while( !$aIterator->IsDone() )
		{
			$sFSOName = $aIterator->Current() ;
			
			// 过滤
			if( !in_array($sFSOName,$arrFilter) )
			{
				$sFSOPath = $sSourcePath .'/'. $sFSOName ;
				$sNewPath = $sTargetPath . '/' . $sFSOName ;
			
				// 拷贝文件
				if( is_file($sFSOPath) )
				{
					if( !copy($sFSOPath,$sNewPath) )
					{
						return false ;
					}
				}
				
				// 递归拷贝子目录
				else if( is_dir($sFSOPath) )			
				{
					if( !self::CopyDir($sFSOPath,$sNewPath) )
					{
						return false ;
					}
				}
				
				else 
				{
					JCAT_ASSERT::ASSERT_(0,'!?')  ;
				}
			}
			
			$aIterator->Next() ;
		}
		
		return true ;
	}
	
	/**
	 * 新建文件
	 * 
	 * @access	public
	 * @param	$sPath					string	文件路径
	 * @param	$bRecursCreateDir		bool	如果目标目录不存在，是否自动窗件目录
	 * @param	$nMode=0766			int		初始权限
	 * @static
	 * @return	bool
	 */
	static public function CreateFile(  $sPath,  $bRecursCreateDir=true,  $nMode=0766, $bThrowException=true ) 
	{
		$sDir = dirname($sPath) ;
		
		// 路径不在一个目录中
		if( is_file($sDir) )
		{
			if( $bThrowException )
			{
				throw new JCAT_Exception( JCAT_Language::SentenceEx('路径： %s 是一个文件，无法在其下创建目录。','JCAT',null,$sDir), __macro_exception_code__ ) ;
			}
			else
			{
				return false ;
			}
		}
		
		// 自动创建上级 不存在
		if( !file_exists($sDir) )
		{
			if(!$bRecursCreateDir)
			{
				if( $bThrowException )
				{
					throw new JCAT_Exception( JCAT_Language::SentenceEx('新建文件操作无法进行，上级目录不存在：%s','JCAT',null,$sDir), __macro_exception_code__ ) ;
				}
				else
				{
					return false ;				
				}
			}
			
			// 创建失败
			if( !mkdir($sDir,0777,true) )
			{
				if( $bThrowException )
				{
					throw new JCAT_Exception( JCAT_Language::SentenceEx('无法创建上级目录：%s','JCAT',null,$sDir), __macro_exception_code__ ) ;
				}
				else
				{
					return false ;
				}
			}
			
			chmod($sDir,0777) ;
		}
		
		
		if( $hFile = fopen($sPath,'a') )
		{
			chmod($sPath,$nMode) ;
			return fclose($hFile) ;
		}
		else
		{
			if( $bThrowException )
			{
				throw new JCAT_Exception( JCAT_Language::SentenceEx('新建文件操作失败：%s','JCAT',null,$sPath), __macro_exception_code__ ) ;
			}
			else
			{
				return false ;
			}
		}
		
	}
	
	/**
	 * 新建目录
	 * 
	 * @access	public
	 * @param	$sPath					string	文件路径
	 * @param	$bRecursCreateDir		bool	如果目标目录不存在，是否自动窗件目录
	 * @param	$nMode=0766			int		初始权限
	 * @static
	 * @return	bool
	 */
	static public function CreateDir(  $sPath,  $bRecursCreateDir=true,  $nMode=0766 ) 
	{
		if( file_exists($sPath) )
		{
			return is_dir($sPath) ;
		}
		
		else 
		{
			mkdir($sPath,$nMode,$bRecursCreateDir)	;
			
			if( !file_exists($sPath) )
			{
				return false ;
			}
			
			chmod($sPath,$nMode) ;
			return true ;
		}
	}

	/**
	 * 当前文件系统，是否对文件名的大小写敏感
	 *
	 * @access	public
	 * @static
	 * @return	bool
	 */
	static public function IsFileSystemCaseSensitive()
	{
		if( PHP_OS=='Linux' )
			return true ;
		
		elseif( strtolower(substr(PHP_OS,0,3))=='win' )
			return false ;
		
		JCAT_ASSERT::ASSERT_(0,'还有什么，请告诉我') ;
	}
	
	
	/**
	 * 判断 路径是否是一个绝对路径
	 * 
	 * @access	public
	 * @param	$sPath	string			what's this
	 * @static
	 * @return	void
	 */
	static public function IsAbsolutePath ($sPath)
	{
		JCAT_ASSERT::ASSERT_STRING($sPath);
		return preg_match('/^(\/|[a-z]:)/i',$sPath) ;
	}
	
	/**
	 * 返回 路径$sFromPath 到 路径$sToPath 的相对路径
	 * 
	 * @access	public
	 * @param	$sFromPath		string	what's this
	 * @param	$sToPath		string	what's this
	 * @static 
	 * @return	string, null
	 */
	static public function GetRelativePath($sFromPath,$sToPath)
	{
		JCAT_ASSERT::ASSERT_STRING($sFromPath) ;
		JCAT_ASSERT::ASSERT_STRING($sToPath) ;
	
		// 如果 $sFromPath 是一个文件，取其目录部分
		if( is_file($sFromPath) )
		{
			$sFrom = dirname($sFromPath) ;
		}
		else
		{
			$sFrom = $sFromPath ;
		}
		
		// 整理路径为统一格式
		$sFrom = JCAT_Global::TidyPath($sFrom) ;
		$sTo = JCAT_Global::TidyPath($sToPath) ;
		
		
		// 切为数组
		$arrFromPath = explode('/',$sFrom) ;
		$arrToPath = explode('/',$sTo) ;
		
		// 排除 空元素
		array_diff($arrFromPath,array('')) ;
		array_diff($arrToPath,array('')) ;
		
		// 开始比较
		$nSameLevel = 0 ;
		while(
			($sFromOneDir = array_shift($arrFromPath)) !== null
			and ($sToOneDir = array_shift($arrToPath))  !== null
			and ($sFromOneDir===$sToOneDir)
		)
		{
			$nSameLevel ++ ;
		}
		
		// 将 相同的 目录 压回 栈中
		if($sFromOneDir!==null)
		{
			array_unshift($arrFromPath,$sFromOneDir) ;
		}
		if($sToOneDir!==null)
		{
			array_unshift($arrToPath,$sToOneDir) ;
		}
		
		// 不在 同一 磁盘驱动器 中(Windows 环境下)
		if($nSameLevel<=0)
		{
			return null ;
		}
		
		// 返回
		$nLevel = count($arrFromPath)-1 ;
		$sRelativePath = ($nLevel>0)? str_repeat( '../', $nLevel ): '' ;
		$sRelativePath.= implode('/',$arrToPath) ;
		
		return $sRelativePath ;
	}
	

	// 属性 ///////////////////////////////////////////////////////////////////////////////
	
	/**
	 * 名称
	 * 
	 * @access	private
	 * @var		string
	 */
	protected $sPath = '' ;
	
	/**
	 * 是否文件
	 * 
	 * @access	private
	 * @var		bool
	 */
	protected $bFile = false ;

}
?>