<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_FSOIterator.php 2025 2009-09-26 15:57:01Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 文件系统对象 迭代器
 *
 * @author		alee
 * @access		public
 */
class JCAT_FSOIterator implements JCAT_IIterator
{


	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$sPath						string	迭代起始目录
	 * @param	$nFlag=self::DEFAULT_FLAG	string	迭代方式, 缺省为 ( self::FILE | self::DIR | self::RETURN_NAME )
	 * @return	void
	 */
	public function JCAT_FSOIterator( $sPath, $nFlag=self::DEFAULT_FLAG )
	{
		if( !is_dir($sPath) )
		{
			throw new JCAT_Exception( JCAT_Language::SentenceEx('参数 $nPath(%s) 必须是一个有效目录。','JCAT',null,$sPath), __macro_exception_code__ ) ;
		}
		
		$this->sPath = $sPath ;
		$this->nIteratorFlag = $nFlag ;
		
		$this->First() ;
	}
	
	// 将迭代 回到开头
	public function First()
	{
		JCAT_ASSERT::ASSERT_DIR($this->sPath) ;

		if( $this->hFiles )
			rewinddir($this->hFiles) ;
		else
			$this->hFiles = opendir($this->sPath) ;
		
		return $this->Next() ;
	}

	function __destruct()
	{
		if( $this->hFiles )
			closedir($this->hFiles) ;
	}


	public function Current()
	{ return $this->Current ;}
	

	public function Next()
	{
		while( ($sFilename = readdir($this->hFiles))!==false )
		{
			$sPath = "{$this->sPath}/{$sFilename}" ;
			//echo $sPath."\r\n" ;
			
			// 点
			if( in_array($sFilename,array('.','..')) )
			{
				if( $this->nIteratorFlag&self::DOT )
					return $this->Current = $this->_ToReturnType($sPath) ;
				else
					continue ;
			}
			
			// 目录
			else if( is_dir($sPath) )
			{
				if( $this->nIteratorFlag&self::DIR )
					return $this->Current = $this->_ToReturnType($sPath) ;
				else
					continue ;
			}
			
			// 文件
			else if( is_file($sPath) )
			{
				if( $this->nIteratorFlag & self::FILE )
					return $this->Current = $this->_ToReturnType($sPath) ;
				else
					continue ;
			}
		}
		
		return $this->Current = null ;
	}


	public function IsDone()
	{ return ($this->Current===null) ; }
	
	
	private function _ToReturnType($sPath)
	{
		if( $this->nIteratorFlag & self::RETURN_PATH )
		{
			$sDir = $sFile  = '' ;

			
			// 包含目录部分
			if( $this->nIteratorFlag & self::RETURN_DIR )
				$sDir = dirname($sPath).'/' ;
			
			// 包含文件名
			if( $this->nIteratorFlag & self::RETURN_NAME )
				$sFile = basename($sPath) ;

			return JCAT_Global::TidyPath($sDir.$sFile) ;
		}
		
		// 以 JCAT_FSO 对象返回
		else
		{
						return JCAT_FSO::Instance($sPath) ;
		}
	}
	
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 迭代方式
	 * 
	 * @access	目录路径
	 * @var		int
	 */
	private $sPath ;
	
	/**
	 * 迭代方式
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nIteratorFlag ;
	
	/**
	 * 子目录 迭代器
	 * 
	 * @access	private
	 * @var		JCAT_FSOIterator
	 */
	private $aChildIterator ;
	
	/**
	 * 文件读取资源句柄
	 * 
	 * @access	private
	 * @var		handle
	 */
	private $hFiles ;
	
	/**
	 * 子目录读取资源句柄
	 * 
	 * @access	private
	 * @var		handle
	 */
	private $aDirsIterator ;


	/**
	 * 当前内容
	 * 
	 * @access	private
	 * @var		JCAT_FSO,string
	 */
	private $Current ;

	
	/**
	 * 迭代文件
	 * 
	 * @access	const
	 * @var		int
	 */
	const FILE = 1 ;
	 
	/**
	 * 迭代目录
	 * 
	 * @access	const
	 * @var		int
	 */
	const DIR = 2 ;
	 
	/**
	 * 迭代 . 和 ..
	 * 
	 * @access	const
	 * @var		int
	 */
	const DOT = 4 ;
	 
	/**
	 * 返回 JCAT_FSO 对象
	 * 
	 * @access	const
	 * @var		int
	 */
	const RETURN_FSO = 0 ;
	 
	/**
	 * 返回 文件名称
	 * 
	 * @access	const
	 * @var		int
	 */
	const RETURN_NAME = 32 ;
	 
	/**
	 * 返回 文件所在目录的路径
	 * 
	 * @access	const
	 * @var		int
	 */
	const RETURN_DIR = 64 ;
	 
	/**
	 * 返回 文件的完整路径
	 * 
	 * @access	const
	 * @var		int
	 */
	const RETURN_PATH = 96 ;
	 
	/**
	 * 缺省方式
	 * self::FILE | self::DIR | self::RETURN_NAME
	 * 
	 * @access	const
	 * @var		int
	 */
	const DEFAULT_FLAG = 35 ;
	 
	 
	 
}
?>