<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_FSOTreeIterator.php 2025 2009-09-26 15:57:01Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/





/**
 * 文件系统对象 迭代器
 *
 * @author		alee
 * @access		public
 */
class JCAT_FSOTreeIterator implements JCAT_IIterator
{


	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$sPath									string	迭代起始目录
	 * @param	$nFlag=JCAT_FSOIterator::DEFAULT_FLAG	string	迭代方式, 缺省为 ( self::FILE | self::DIR | self::RETURN_NAME )
	 * @param	$bDepthFirst=false						tring	深度优先
	 * @return	void
	 */
	public function JCAT_FSOTreeIterator( $sPath, $nFlag=JCAT_FSOIterator::DEFAULT_FLAG, $bDepthFirst=false )
	{
		if( !is_dir($sPath) )
		{
			throw new JCAT_Exception( JCAT_Language::SentenceEx('参数 $nPath 必须是一个有效目录。','JCAT',null), __macro_exception_code__ ) ;
		}
		JCAT_ASSERT::ASSERT_INT($nFlag) ;
		JCAT_ASSERT::ASSERT_BOOL($bDepthFirst) ;
		
		$this->sPath = $sPath ;
		$this->nFlag = $nFlag ;
		$this->bDepthFirst = $bDepthFirst ;


		// 为本层内容 和 下级目录 创建 迭代器
		$arrIterators = array() ;
		
		// 广度优先：先设置 本层内容迭代器
		if(!$this->bDepthFirst)
			$arrIterators[] = new JCAT_FSOIterator($this->sPath, $this->nFlag) ;
		
		// 各个子目录迭代器
		$aSubDirIterator = new JCAT_FSOIterator($this->sPath,JCAT_FSOIterator::DIR|JCAT_FSOIterator::RETURN_PATH) ;
		$aSubDirIterator->First() ;
		while( !$aSubDirIterator->IsDone() )
		{
			$arrIterators[] = $aSubDirIterator->Current() ;
			$aSubDirIterator->Next() ;
		}
		
		// 深度优先：最后 设置 本层内容迭代器
		if($this->bDepthFirst)
			$arrIterators[] = new JCAT_FSOIterator($this->sPath, $this->nFlag) ;
			
		$this->aIteratorIterator = new JCAT_ArrayIterator($arrIterators) ;
		
		
		// 第一项
		$this->First() ;
	}
	
	// 将迭代 回到开头
	public function First()
	{
		$this->aIteratorIterator->First() ;
		
		// 设置当前迭代器
		$this->aCurrentIterator = $this->GetNextIterator() ;
		
		return $this->Current() ;
	}

	

	public function Current()
	{
		return $this->aCurrentIterator->Current() ;
	}
	

	public function Next()
	{
		$Ret = $this->aCurrentIterator->Next() ;
		if( !$this->aCurrentIterator->IsDone() )
			return $Ret ;
		
		// 换到下一个
		else
		{
			$this->aCurrentIterator = $this->GetNextIterator() ;
			return $this->aCurrentIterator->Current() ;
		}
	}
	
	
	public function IsDone()
	{
		return $this->aCurrentIterator->IsDone() ;
	}
	
	
	private function GetNextIterator()
	{
		$aIterator = null ;
		while( !$this->aIteratorIterator->IsDone() )
		{
			// 取出一项迭代器
			$Iterator = $this->aIteratorIterator->Current() ;
			$this->aIteratorIterator->Next() ;

			if( is_string($Iterator) )
				$aIterator = new self($Iterator,$this->nFlag,$this->bDepthFirst) ;
			else
				$aIterator = $Iterator ;

			// 移到第一项
			$aIterator->First() ;

			// 非空迭代器
			if( !$aIterator->IsDone() )
				break ;
			
			else
				$aIterator = null ;

		}
		
		if( $aIterator===null )
			$aIterator = new JCAT_NullIterator() ;
		
		return $aIterator ;
	}
	
	
	
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////
	
	/**
	 * 深度优先
	 * 
	 * @access	private
	 * @var		bool
	 */
	private $bDepthFirst ;
	
	/**
	 * 迭代方式
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nFlag ;
	
	/**
	 * 本层目录
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sPath ;
	
	
		
	/**
	 * 所有可用迭代器（包括 子目录迭代器 和 本目录 迭代器 ）
	 * 
	 * @access	private
	 * @var		JCAT_FSOIterator
	 */
	private $arrIterators = array() ;


	/**
	 * 当前迭代器
	 * 
	 * @access	private
	 * @var		JCAT_FSOIterator
	 */
	private $aCurrentIterator ;

	 
	 
}

?>