<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_UploadImage.php 1876 2009-05-28 06:37:05Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


class JCAT_UploadImage extends JCAT_UploadFile
{
	public function UploadPhoto($sStoreDir,$sAllowExt=null,$nMaxByte=null,$nMaxWidth=null,$nMaxHeight=null)
	{
		if( $sAllowExt==null )
		{
			$sAllowExt = self::ALLOWEXT ;
		}

		$this->JCAT_UploadFile($sAllowExt,$nMaxByte,$sStoreDir) ;
		
		$this->nMaxWidth = ($nMaxWidth==null)? self::MAXWIDTH: $nMaxWidth ;
		$this->nMaxHeight = ($nMaxHeight==null)? self::MAXHEIGHT: $nMaxHeight ;
	}
	
				
	const ERR_NOTIMG = 11 ;									// 不是有效图像类型
	const ERR_EXWIDTH = 12 ;									// 图像宽度超过限制
	const ERR_EXHEIGHT = 13 ;								// 图像高度超过限制

	static public $ALLOWEXT = array('gif','jpg','png','bmp','swf') ;
																// 允许上传的 图片扩展名
	static public $UNALLOWEXT = array() ;					// 禁止上传的 图片扩展名
	static public $MAXWIDTH = 1024 ;							// 上传图片 宽度限制
	static public $MAXHEIGHT = 800 ;							// 上传图片 高度限制
	
	protected $nMaxWidth ;	
	protected $nMaxHeight ;	
	
	protected $arrImageInfo ;
	
	public function Upload($sInputName,JCAT_Request $aRequest=null)
	{
		// 上传
		if( !JCAT_UploadFile::Upload($sInputName,$aRequest) )
		{
			return false ;
		}
		
		// 获得 图像信息
		$this->arrImageInfo[$sInputName] = getimagesize( $this->GetStorePath($sInputName) ) ;
		if($this->arrImageInfo[$sInputName]===false)
		{
			$this->CancelUpload() ;
			$this->_PutErrorInfo($sInputName,'上传的文件不是有效的图片类型：“'.$this->GetOriginalName($sInputName).'”',self::ERR_NOTIMG) ;
			return false ;
		}

		// 检查 图像宽度
		$nWidth = $this->GetPhotoWidth() ;
		if( $this->nMaxWidth>0 and $this->nMaxWidth<$nWidth )
		{
			$this->CancelUpload() ;
			$this->_PutErrorInfo($sInputName,"图片宽度（{$nWidth} px）超过限制（{$this->nMaxWidth} px）",self::ERR_EXWIDTH) ;
			return false ;
		}

		// 检查 图像高度
		$nHeight = $this->GetPhotoHeight() ;
		if( $this->nMaxHeight>0 and $this->nMaxHeight<$nHeight )
		{
			$this->CancelUpload() ;
			$this->_PutErrorInfo($sInputName,"图片高度（{$nHeight} px）超过限制（{$this->nMaxHeight} px）",self::ERR_EXHEIGHT) ;
			return false ;
		}
		
		return true ;
	}
	
	public function GetPhotoWidth($sInputName=null)
	{ return $this->arrImageInfo[ ($sInputName==null)?$this->sLastInput:$sInputName ][0] ; }
	
	public function GetPhotoHeight($sInputName=null)
	{ return $this->arrImageInfo[ ($sInputName==null)?$this->sLastInput:$sInputName ][1] ; }
	
	public function GetPhotoType($sInputName=null)
	{ return $this->arrImageInfo[ ($sInputName==null)?$this->sLastInput:$sInputName ][2] ; }
	
	public function SetMaxSize($nMaxWidth=0,$nMaxHeight=0)
	{
		$this->nMaxWidth = $nMaxWidth ;
		$this->nMaxHeight = $nMaxHeight ;
	}
	
	public function GetMaxWidth()
	{ return $this->nMaxWidth ; }
	
	public function GetMaxHeight()
	{ return $this->nMaxHeight ; }

}

?>