<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_MessageGtkDialogPrinter.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/





/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_MessageGtkDialogPrinter
	extends JCAT_GtkDialog 
	implements JCAT_IMessagePrinter
{
	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	array
	 */
	public function JCAT_MessageGtkDialogPrinter( JCAT_MessageQueue $aMsgQueue )
	{
		$this->aMsgQueue = $aMsgQueue ;
		$this->JCAT_GtkDialog(__CLASS__,'JCAT_MessageGtkDialogPrinter.glade','MainDlg') ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aMsg	JCAT_Message	What's this Parameter ?
	 * @return	void
	 */
	public function PrintMessage( JCAT_Message $aMsg ) 
	{
		// 创建对话框的 主窗体
		if( !$this->GetWidget() )
		{
			$this->Create() ;
		}

		$wndMsgQueue = $this->GetChildWidget('VBoxMsgQueue') ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndMsgQueue,'GtkVBox');
		
		// 创建 Label 窗体
		$sMsgWord = $aMsg->GetMessage() ;
		$sMsgStyleName = 'JCAT_'.$aMsg->GetType() ;

		$wndMsgLabel = new GtkLabel($sMsgWord,false) ;
		$wndMsgLabel->set_name('JCAT_MSGMVC_BAD') ;		// 消息文本
		$wndMsgLabel->set_text($sMsgWord) ;					// 消息文本
		$wndMsgLabel->set_use_underline(true) ;				// 下划线
		$wndMsgLabel->set_line_wrap(true) ;					// 自动换行
		$wndMsgLabel->set_selectable(true) ;					// 可选中
		$wndMsgLabel->set_alignment(0,0) ;					// 对齐
		$wndMsgLabel->set_padding(8,3) ;						// 空间
		
		$wndMsgLabel->set_visible(true) ;

		// 加入到  VBox 中
		$wndMsgQueue->pack_end($wndMsgLabel,false,true,0) ;
	}

	
	


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aMsgQueue	JCAT_MessageQueue	What's this Parameter ?
	 * @return	void
	 */
	public function PrintQueue( JCAT_MessageQueue $aMsgQueue ) 
	{		
		// 显示对话框
		$this->DoDialog() ;
	}


	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Delete()
	{
		$this->aMsgQueue = null ;
	} 
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	array
	 */
	public function OnOk()
	{		
		$wndChkClearMsgQueue = $this->GetChildWidget('ChkClearMsgQueue') ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndChkClearMsgQueue,'GtkCheckButton');
		
		// 清空消息
		if( $wndChkClearMsgQueue->get_active() )
		{
			$this->Clear() ;
		}
		
		parent::OnOk() ;
	}
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	array
	 */
	public function Clear()
	{		
		$wndMsgQueue = $this->GetChildWidget('VBoxMsgQueue') ;
		JCAT_ASSERT::ASSERT_INSTANCE($wndMsgQueue,'GtkVBox');
		
		// 清除 label
		$arrChildrenLabel = $wndMsgQueue->get_children() ;
		foreach($arrChildrenLabel as $wndLabel)
		{
			$wndMsgQueue->remove($wndLabel) ;
		}
		
		// 清除消息队列中的  消息
		if( $this->aMsgQueue )
		{
			$this->aMsgQueue->ClearMessage() ;
		}
	}

	
	// 属性 ///////////////////////////////////////////////////////////////////////////////

	private $wndDialog ; 
	
	private $aMsgQueue ; 
}
?>