<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_MessageQueue.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_MessageQueue
{
	
	public function JCAT_MessageQueue( $nMaxMsgCount=30 )
	{
		$this->nMaxMsgCount = $nMaxMsgCount ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aFilter	JCAT_IMessageFilter	What's this Parameter ?
	 * @return	void
	 */
	public function AddFilter( JCAT_IMessageFilter $aFilter ) 
	{
		if( !in_array($aFilter,$this->arrFilters) )
			$this->arrFilters[] = $aFilter ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aPrinter	JCAT_IMessagePrinter	What's this Parameter ?
	 * @return	void
	 */
	public function AddPrinter( JCAT_IMessagePrinter $aPrinter ) 
	{
		if( !in_array($aPrinter,$this->arrPrinters) )
			$this->arrPrinters[] = $aPrinter ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aLog	JCAT_TxtLog	What's this Parameter ?
	 * @return	void
	 */
	public function AddLog( JCAT_TxtLog $aLog ) 
	{
		if( !in_array($aLog,$this->arrLogs) )
			$this->arrLogs[] = $aLog ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	JCAT_Message $aMsg		What's this Parameter ?
	 * @return	void
	 */
	public function PutInMessage(  JCAT_Message $aMsg ) 
	{
		// 过滤消息
		foreach($this->arrFilters as $aFilter)
		{
			if( !$aFilter->Filter($aMsg) )
			{
				return ;
			}
		}
		
		// 入队
		$this->arrMsgQueue[] = $aMsg ;

		// 清理超出	
		$nMore = count($this->arrMsgQueue) - $this->nMaxMsgCount ;
		if( $nMore>0 )
		{
			$arrForRemove = array_keys($this->arrMsgQueue) ;
			sort($arrForRemove) ;
			while( $nMore-- )
			{
				unset( $this->arrMsgQueue[array_shift($arrForRemove)] ) ;
			}
		}

		// 输出消息
		foreach($this->arrPrinters as $aPrinter)
		{
			$aPrinter->PrintMessage($aMsg) ;
		}
	}
	
	
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	int
	 */
	public function ClearMessage()
	{
		$nRet = count($this->arrMsgQueue) ;
		$this->arrMsgQueue = array() ;
		return $nRet ;
	}

	

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	JCAT_ArrayIterator
	 */
	public function CreateMessageIterator(  ) 
	{
				return new JCAT_ArrayIterator($this->arrMsgQueue) ;
	}
	
	/**
	 * 返回消息数量
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetMessageCount()
	{
		return count($this->arrMsgQueue) ;		
	}
	



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function PrintQueue() 
	{
		foreach($this->arrPrinters as $aPrinter)
		{
			$aPrinter->PrintQueue($this) ;
		}
	}



	
	/**
	 * 回收对象
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Delete()
	{
		// 清除消息
		$this->ClearMessage() ;
		
		// 解除所有注册的消息类型
		JCAT_MessageDispatcher::RemoveMessageQueue($this) ;
		
		// 解除所有的消息Printer
		foreach ($this->arrPrinters as $nIdx=>$aPinter)
		{
			$aPinter->Delete() ;
			unset($this->arrPrinters[$nIdx]) ;
		}
		
		// 解除所有的消息Filter
		$this->arrFilters = array() ;
	}

	// 属性 ///////////////////////////////////////////////////////////////////////////////


	private $arrFilters = array() ;
	
	private $arrPrinters = array() ;
	
	private $arrLogs = array() ;
	
	private $arrMsgQueue = array() ;
	
	private $nMaxMsgCount = 30 ;
}


?>