<?php
// Call JCAT_ArrayIteratorTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_ArrayIteratorTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/Project/JeCat/JCAT0.2/trunk/JCAT.Framework_0.2.0/lib.php/Application/Pattern/class.JCAT_ArrayIterator.php';

/**
 * Test class for JCAT_ArrayIterator.
 * Generated by PHPUnit on 2007-12-20 at 18:15:06.
 */
class JCAT_ArrayIteratorTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_ArrayIteratorTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testCurrentKey().  正向迭代测试
     */
    public function testWayA() {
        
		$arr = array (
			'a','b','c','d','e','f','g'
		) ;
		
		$aIterator = new JCAT_ArrayIterator($arr) ;
		$this->assertEquals($aIterator->First(),'a') ;

		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Current(),'a') ;
		$this->assertEquals($aIterator->CurrentKey(),'0') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->next(),'b') ;
		$this->assertEquals($aIterator->Current(),'b') ;
		$this->assertEquals($aIterator->CurrentKey(),'1') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->next(),'c') ;
		$this->assertEquals($aIterator->Current(),'c') ;
		$this->assertEquals($aIterator->CurrentKey(),'2') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->next(),'d') ;
		$this->assertEquals($aIterator->Current(),'d') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->next(),'e') ;
		$this->assertEquals($aIterator->Current(),'e') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->next(),'f') ;
		$this->assertEquals($aIterator->Current(),'f') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->next(),'g') ;
		$this->assertEquals($aIterator->Current(),'g') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->next(),null) ;
		$this->assertEquals($aIterator->Current(),null) ;
		
		$this->assertTrue($aIterator->IsDone()) ;
    }

    /**
     * @todo Implement testFirst().  反向迭代测试
     */
    public function testWayB() {
	
		$arr = array (
			'a','b','c','d','e','f','g'
		) ;
		
		$aIterator = new JCAT_ArrayIterator($arr) ;
		$this->assertEquals($aIterator->Last(),'g') ;
		$this->assertEquals($aIterator->CurrentKey(),'6') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Current(),'g') ;
		$this->assertEquals($aIterator->CurrentKey(),'6') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Previous(),'f') ;
		$this->assertEquals($aIterator->Current(),'f') ;
		$this->assertEquals($aIterator->CurrentKey(),'5') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Previous(),'e') ;
		$this->assertEquals($aIterator->Current(),'e') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Previous(),'d') ;
		$this->assertEquals($aIterator->Current(),'d') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Previous(),'c') ;
		$this->assertEquals($aIterator->Current(),'c') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Previous(),'b') ;
		$this->assertEquals($aIterator->Current(),'b') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Previous(),'a') ;
		$this->assertEquals($aIterator->Current(),'a') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Previous(),null) ;
		$this->assertEquals($aIterator->Current(),null) ;
		
		$this->assertTrue($aIterator->IsDone()) ;
    }

}

// Call JCAT_ArrayIteratorTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_ArrayIteratorTest::main')
	JCAT_ArrayIteratorTest::main();
?>
