<?php
// Call JCAT_ArrayReverseIteratorTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_ArrayReverseIteratorTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/Project/JeCat/JCAT0.2/trunk/JCAT.Framework_0.2.0/lib.php/Application/Pattern/class.JCAT_ArrayReverseIterator.php';

/**
 * Test class for JCAT_ArrayReverseIterator.
 * Generated by PHPUnit on 2007-12-20 at 18:15:19.
 */
class JCAT_ArrayReverseIteratorTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_ArrayReverseIteratorTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testCurrentKey().  正向迭代测试： 从后向前历遍数组
     */
    public function testWayA() {
        
		$arr = array (
			'a','b','c','d','e','f','g'
		) ;
		
		$aIterator = new JCAT_ArrayReverseIterator($arr) ;
		$this->assertEquals($aIterator->First(),'g') ;
		$this->assertEquals($aIterator->CurrentKey(),'6') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Current(),'g') ;
		$this->assertEquals($aIterator->CurrentKey(),'6') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Next(),'f') ;
		$this->assertEquals($aIterator->Current(),'f') ;
		$this->assertEquals($aIterator->CurrentKey(),'5') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Next(),'e') ;
		$this->assertEquals($aIterator->Current(),'e') ;
		$this->assertEquals($aIterator->CurrentKey(),'4') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Next(),'d') ;
		$this->assertEquals($aIterator->Current(),'d') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Next(),'c') ;
		$this->assertEquals($aIterator->Current(),'c') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Next(),'b') ;
		$this->assertEquals($aIterator->Current(),'b') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Next(),'a') ;
		$this->assertEquals($aIterator->Current(),'a') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Next(),null) ;
		$this->assertEquals($aIterator->Current(),null) ;
		
		$this->assertTrue($aIterator->IsDone()) ;
    }

    /**
     * @todo Implement testFirst().  反向迭代测试： 从前向后历遍数组
     */
    public function testWayB() {
	
		$arr = array (
			'a','b','c','d','e','f','g'
		) ;
		
		$aIterator = new JCAT_ArrayReverseIterator($arr) ;
		$this->assertEquals($aIterator->Last(),'a') ;
		$this->assertEquals($aIterator->CurrentKey(),'0') ;

		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Current(),'a') ;
		$this->assertEquals($aIterator->CurrentKey(),'0') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Previous(),'b') ;
		$this->assertEquals($aIterator->Current(),'b') ;
		$this->assertEquals($aIterator->CurrentKey(),'1') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Previous(),'c') ;
		$this->assertEquals($aIterator->Current(),'c') ;
		$this->assertEquals($aIterator->CurrentKey(),'2') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Previous(),'d') ;
		$this->assertEquals($aIterator->Current(),'d') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Previous(),'e') ;
		$this->assertEquals($aIterator->Current(),'e') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Previous(),'f') ;
		$this->assertEquals($aIterator->Current(),'f') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Previous(),'g') ;
		$this->assertEquals($aIterator->Current(),'g') ;
		
		$this->assertFalse($aIterator->IsDone()) ;
		$this->assertEquals($aIterator->Previous(),null) ;
		$this->assertEquals($aIterator->Current(),null) ;
		
		$this->assertTrue($aIterator->IsDone()) ;
	}
}

// Call JCAT_ArrayReverseIteratorTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_ArrayReverseIteratorTest::main')
	JCAT_ArrayReverseIteratorTest::main();
?>
