<?php
// Call JCAT_FlyweightTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_FlyweightTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/Project/JeCat/JCAT0.2/trunk/JCAT.Framework_0.2.0/lib.php/Application/Pattern/class.JCAT_Flyweight.php';


class a implements JCAT_IFlyweight
{
	
	static public function GetFlyweightKey()
	{
		$arrArgs = func_get_args() ;
		return $arrArgs[0] ;
	}
	
	
	static public function CreateInstance()
	{ return new self() ; }
	
	public $aa = 0 ;
}


/**
 * Test class for JCAT_Flyweight.
 * Generated by PHPUnit on 2007-12-20 at 17:03:19.
 */
class JCAT_FlyweightTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_FlyweightTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testGetGlobalInstance().
     */
    public function testThis() {
        
		$this->assertFalse( JCAT_Flyweight::IsFlyweightClass('a') ) ;
		JCAT_Flyweight::RegistorInstanceFactory('a',array('a','CreateInstance')) ;
		
		$this->assertTrue( JCAT_Flyweight::IsFlyweightClass('a') ) ;
		
		$a1 = JCAT_Flyweight::GetGlobalInstance('a','1') ;
		$a2 = JCAT_Flyweight::GetGlobalInstance('a','2') ;
		$a3 = JCAT_Flyweight::GetGlobalInstance('a','3') ;
		
		$a1->aa = 1 ;
		$a2->aa = 2 ;
		$a3->aa = 3 ;
		
		
		$A1 = JCAT_Flyweight::GetGlobalInstance('a','1') ;
		$A2 = JCAT_Flyweight::GetGlobalInstance('a','2') ;
		$A3 = JCAT_Flyweight::GetGlobalInstance('a','3') ;
		
		$this->assertEquals( $A1->aa, 1 ) ;
		$this->assertEquals( $A2->aa, 2 ) ;
		$this->assertEquals( $A3->aa, 3 ) ;
		
		$this->assertEquals( $A1, $a1 ) ;
		$this->assertEquals( $A2, $a2 ) ;
		$this->assertEquals( $A3, $a3 ) ;
		
		$this->assertNotEquals( $A3, $a1 ) ;
		$this->assertNotEquals( $A2, $a1 ) ;
		$this->assertNotEquals( $A3, $a2 ) ;
		
		
		
    }

}

// Call JCAT_FlyweightTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_FlyweightTest::main')
	JCAT_FlyweightTest::main();
?>
