<?php
// Call JCAT_SingletonTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD'))
	define('PHPUnit_MAIN_METHOD', 'JCAT_SingletonTest::main');


require_once 'PHPUnit/Framework.php';

require_once '/home/alee/Project/JeCat/JCAT0.2/trunk/JCAT.Framework_0.2.0/lib.php/Application/Pattern/class.JCAT_Singleton.php';


class a implements JCAT_ISingleton
{
	public $aa = 0 ;
}

class b
{
	static function bb($n=-1)
	{ 
		$b = new b() ;
		if($n>=0)
			$b->bb = $n ;
		return $b ;
	} 
	public $bb = 0 ;
}






/**
 * Test class for JCAT_Singleton.
 * Generated by PHPUnit on 2007-12-20 at 15:45:46.
 */
class JCAT_SingletonTest extends PHPUnit_Framework_TestCase
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 */
	public static function main()
	{
		require_once 'PHPUnit/TextUI/TestRunner.php';

		$suite  = new PHPUnit_Framework_TestSuite('JCAT_SingletonTest');
		$result = PHPUnit_TextUI_TestRunner::run($suite);
	}

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 */
	protected function setUp()
	{
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 */
	protected function tearDown()
	{
	}

    /**
     * @todo Implement testGetGlobalInstance().
     */
    public function testThis() {
        
		$this->assertTrue(JCAT_Singleton::IsSingletonClass('a')) ;
		$this->assertFalse(JCAT_Singleton::IsSingletonClass('b')) ;
		
		JCAT_Singleton::RegistorInstanceFactory('b',array('b','bb')) ;
		$this->assertTrue(JCAT_Singleton::IsSingletonClass('b')) ;
		
		// 初次创建
		$a = JCAT_Singleton::GetGlobalInstance('a') ;
		$b = JCAT_Singleton::GetGlobalInstance('b',10) ;
		
		$this->assertEquals($a->aa,0) ;
		$this->assertEquals($b->bb,10) ;
		
		$a->aa = 100 ;
		$b->bb = 200 ;
		
		// 再次调用
		$a2 = JCAT_Singleton::GetGlobalInstance('a') ;
		$b2 = JCAT_Singleton::GetGlobalInstance('b') ;
		
		$this->assertEquals($a2->aa,100) ;
		$this->assertEquals($b2->bb,200) ;
    }

}

// Call JCAT_SingletonTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'JCAT_SingletonTest::main')
	JCAT_SingletonTest::main();
?>
