<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ArrayIterator.php 1916 2009-07-03 10:17:43Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


include_once (dirname(__FILE__).'/interface.JCAT_IBothwayIterator.php') ;
include_once (dirname(__FILE__).'/interface.JCAT_IHashTableIterator.php') ;


/**
 * 数组迭代器，为数组提供一致的迭代操作
 *
 * @author		alee
 * @access		public
 */
class JCAT_ArrayIterator implements JCAT_IBothwayIterator, JCAT_IHashTableIterator
{
	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$arrArray	array	目标数组
	 * @return	void
	 */
	public function JCAT_ArrayIterator( array $arrArray )
	{
		$this->arrTheArray = $arrArray ;
		$this->First() ;
	}



	/**
	 * 返回 数组 当前的 键值
	 * 
	 * @access	public
	 * @return	string
	 */
	public function CurrentKey(  ) 
	{ return key($this->arrTheArray) ; }


	/**
	 * 返回第一项，迭代开始
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function First()
	{
		$Item = reset($this->arrTheArray) ;
		return ($Item===false)? null: $Item ;
	}



	/**
	 * 迭代之下一个
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Next()
	{ 
		$Item = next($this->arrTheArray) ;
		return ($Item===false)? null: $Item ;
	}



	/**
	 * 返回当前内容
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Current()
	{ return current($this->arrTheArray) ; }



	/**
	 * 迭代 退至前一个，如果超过第一个，迭代终止
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Previous()
	{ 
		$Item = prev($this->arrTheArray) ;
		return ($Item===false)? null: $Item ;
	}



	/**
	 * 返回最后一项，迭代终止
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Last()
	{ return end($this->arrTheArray) ; }

	/**
	 * 迭代是否完成
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function IsDone()
	{ return (current($this->arrTheArray)===false) ; }

	/**
	 * Description
	 *
	 * @access	protected
	 * @return	array
	 */
	protected function & GetArrayRef()
	{
		return $this->arrTheArray ;
	}

	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 对目标数组的引用
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrTheArray = null ;


}
/*macro_exception_code:0*/
?>