<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_FiltrationIterator.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/





/**
 * 为现有迭代器提供可过滤能力，它是一个 JCAT_IIterator 对象的“装饰”类
 *
 * @author		alee
 * @access		public
 */
class JCAT_FiltrationIterator implements JCAT_IBothwayIterator
{
	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param	$aIterator		JCAT_IIterator	源迭代器
	 * @return	void
	 */
	public function JCAT_FiltrationIterator(JCAT_IIterator $aIterator, array $arrFilters = array() )
	{
		JCAT_ASSERT::ASSERT_ISTHESE($arrFilters,array('array:JCAT_IIteratorFilter'));
		
		$this->arrFilters = $arrFilters ;
		$this->aIterator = $aIterator ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function AddFilter(JCAT_IIteratorFilter $aFilter)
	{
		$this->arrFilters[] = $aFilter ;
	}

	/**
	 * Description
	 *
	 * @access	private
	 * @return	mixed
	 */
	private function Operate($sOp,$sNextOp)
	{
		$Item = $this->aIterator->$sOp() ;
		
		while($Item!==null)
		{
			if( $this->Filtrate($Item) )
			{
				return $Item ;
			}
			
			$Item = $this->aIterator->$sNextOp() ;
		}
		
		return null ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$Item	mixed
	 * @return	bool
	 */
	private function Filtrate($Item)
	{
		foreach ($this->arrFilters as $aFilter)
		{
			if( !$aFilter->Filtrate($this->aIterator,$Item) )
			{
				return false ;
			}
		}
		
		return true ;
	}

	/**
	 * 返回第一项，迭代开始
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function First()
	{
		return $this->Operate('First','Next') ;
	}



	/**
	 * 迭代之下一个
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Next()
	{ 
		return $this->Operate('Next','Next') ;
	}



	/**
	 * 返回当前内容
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Current()
	{
		return $this->aIterator->Current() ;
	}



	/**
	 * 迭代 退至前一个，如果超过第一个，迭代终止
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Previous()
	{ 
		return $this->Operate('Previous','Previous') ;
	}



	/**
	 * 返回最后一项，迭代终止
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function Last()
	{
		return $this->Operate('Last','Previous') ;
	}

	/**
	 * 迭代是否完成
	 * 
	 * @access	public
	 * @return	mixed
	 */
	public function IsDone()
	{
		return $this->aIterator->IsDone() ;
	}


	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * 过滤器
	 * 
	 * @access	private
	 * @var		array:JCAT_IIteratorFilter
	 */
	private $arrFilters = array() ;
	
	/**
	 * 源迭代器
	 * 
	 * @access	private
	 * @var		JCAT_IIterator
	 */
	private $aIterator = null ;


}
/*macro_exception_code:0*/
?>