<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_MultiIterator.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * link same iterates as a single iterator
 * putin same iterators, and iterate all of them
 *
 * @author		alee
 * @access		public
 */
class JCAT_MultiIterator implements JCAT_IIterator
{
	/**
	 * 构造函数
	 * 
	 * @access	public
	 * @param 	$arrIterators		array:JCAT_IIterator
	 * @return	void
	 */
	public function JCAT_MultiIterator(array $arrIterators=array())
	{
		JCAT_ASSERT::ASSERT_ISTHESE($arrIterators,array('array:JCAT_IIterator')
				, JCAT_Language::SentenceEx('JCAT_RecursionIterator 构造函数的参数 $arrIterators 的所有元素都必须为 JCAT_IIterator 对象。','JCAT',null));
		
		$this->arrIterators = $arrIterators ;
		
		// the iterators's iterator ^_^!
		$this->aIteratorsIterator = new JCAT_ArrayIterator($this->arrIterators) ;
	}

	/**
	 * add a iterator
	 * 
	 * @access	public
	 * @param 	$aIterator		JCAT_IIterator
	 * @return	void
	 */
	public function AddIterator(JCAT_IIterator $aIterator)
	{
		$this->arrIterators[] = $aIterator ;
	}
	

	/**
	 * Description
	 *
	 * @access	private
	 * @param 	$sTry			string		First/Next/Previous/Last
	 * @param 	$sTill			string		First/Next/Previous/Last
	 * @param 	$sSwitch		string		First/Next/Previous/Last
	 * @return	W3B_DependenceItem
	 */
	private function Iterate($sTry,$sTill,$sSwitch)
	{
		while( $aIterator=$this->aIteratorsIterator->Current() )
		{
			$aItem = $aIterator->$sTry() ;
			if($aItem)
			{
				return $aItem ;
			}
			
			else 
			{
				$aIterator = $this->aIteratorsIterator->$sTill() ;
				
				// 所有迭代器 全部完成		
				if( !$aIterator )
				{
					return null ;
				}
				
				else
				{
					if( $aItem=$aIterator->{$sSwitch}() )
					{
						return $aItem ;
					}
					
					else
					{
						continue ;
					}
				}
			}
		}
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	mixed
	 */
	public function First()
	{
		$this->aIteratorsIterator->First() ;
		return $this->Iterate('First','Next','First') ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	mixed
	 */
	public function Next()
	{
		return $this->Iterate('Next','Next','First') ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	mixed
	 */
	public function Current()
	{
		$aIterator = $this->aIteratorsIterator->Current() ;
		return $aIterator? $aIterator->Current(): null ;		
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsDone()
	{
		$aIterator = $this->aIteratorsIterator->Current() ;
		return $aIterator? $aIterator->IsDone(): true ;	
	}

	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * iterators
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrIterators = null ;
	
	
	/**
	 * iterator for total iterators
	 * 
	 * @access	private
	 * @var		JCAT_IIterator
	 */
	private $aIteratorsIterator ;


}

/*
// test case
$arrIterators = array() ;
$arrIterators[] = new JCAT_NullIterator() ;
$arrIterators[] = new JCAT_ArrayIterator(array(1,2,3,4)) ;
$arrIterators[] = new JCAT_ArrayIterator(array('a','b','c')) ;
$arrIterators[] = new JCAT_NullIterator() ;
$arrIterators[] = new JCAT_ArrayIterator(array('A')) ;
$arrIterators[] = new JCAT_NullIterator() ;

$aMultiIterator = new JCAT_MultiIterator($arrIterators) ;

$arrIterators2 = array() ;
$arrIterators2[] = $aMultiIterator ;
$arrIterators2[] = new JCAT_NullIterator() ;
$arrIterators2[] = new JCAT_ArrayIterator(array(1,2,3,4)) ;
$arrIterators2[] = new JCAT_ArrayIterator(array('a','b','c')) ;
$arrIterators2[] = new JCAT_NullIterator() ;

$aMultiIterator2 = new JCAT_MultiIterator($arrIterators2) ;
for ($aMultiIterator2->First();!$aMultiIterator2->IsDone();$aMultiIterator2->Next())
{
	echo $aMultiIterator2->Current(), "<br />\r\n" ;
}
*/

/*macro_exception_code:0*/
?>