<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_Request.php 2022 2009-09-24 15:20:12Z aleechou $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/

class JCAT_Request
{
	const TYPE_CUS = 1 ;
	const TYPE_GET = 2 ;
	const TYPE_POST = 4 ;
	const TYPE_COOKIE = 8 ;
	const TYPE_FILES = 16 ;
	const TYPE_CL = 32 ;
	const TYPE_SERVER = 64 ;
	
	const TYPE_REQUEST = 14 ;	// TYPE_POST|TYPE_GET|TYPE_COOKIE
	const TYPE_PARAM = 47 ;		// TYPE_REQUEST|TYPE_CUS|TYPE_CL
	const TYPE_ALL = 127 ;	
	const TYPE_DEFAULT = 127 ;	// TYPE_CUS|TYPE_REQUEST|TYPE_FILES|TYPE_CL|TYPE_SERVER
	
	const MAKEURL_PATH = 512 ;
	const MAKEURL_HOST = 1024 ;
	const MAKEURL_DEFAULT = 514 ; // MAKEURL_PATH|TYPE_GET
	
	const FULL_URL = 'FULL_URL' ;
	const FULL_SCRIPT = 'FULL_SCRIPT' ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_Request
	 */
	public function JCAT_Request($nRequestType=self::TYPE_DEFAULT,$sCLPPClassName=null)
	{
		$this->SetRequestType($nRequestType) ;
		
		// parse params from cl
		if( !self::IsHTTPRequest() )
		{
			if( !$sCLPPClassName )
			{
				$sCLPPClassName = self::$sDefaultCLPP ;
			}
			JCAT_ASSERT::ASSERT_ISCLASS($sCLPPClassName,'JCAT_ICommandLineParamParser',JCAT_Language::SentenceEx('参数 $sCLPPClassName(%s) 必须实现 JCAT_ICommandLineParamParser 接口。','JCAT',null));
			
			$aCLParamParser = new $sCLPPClassName() ;
			
			$arrArgvs = self::GetCommandLineParams() ;
			$this->arrCLParams = $aCLParamParser->Parse($arrArgvs) ;			
		}
		
		$this->arrParamSources = array(
			self::TYPE_CUS => &$this->arrCusParams
			, self::TYPE_POST => &$_POST
			, self::TYPE_GET => &$_GET
			, self::TYPE_COOKIE => &$_COOKIE
			, self::TYPE_FILES => &$_FILES
			, self::TYPE_CL => &$this->arrCLParams
			, self::TYPE_SERVER => &$_SERVER			
		) ;
		
		if( JCAT::$TYPE==JCAT::TYPE_HTML )
		{
			// 
			$this->SetParam(self::FULL_URL,
					'http://'.$this->GetParam('HTTP_HOST').$this->GetParam('REQUEST_URI') );
			$this->SetParam(self::FULL_SCRIPT,
					'http://'.$this->GetParam('HTTP_HOST').$this->GetParam('PHP_SELF') );
		}
	}
	
	/**
	 * 设置对象属性 nRequestType
	 *
	 * @access	public
	 * @param	$nRequestType		int	nRequestType
	 * @return	void
	 */
	public function SetRequestType($nRequestType=self::TYPE_DEFAULT)
	{
		JCAT_ASSERT::ASSERT_INT($nRequestType) ;
		$this->nRequestType = $nRequestType ;
	}
	
	/**
	 * 取得对象属性 nRequestType
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetRequestType()
	{
		return $this->nRequestType ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_Request
	 */
	static public function GetGlobalInstance()
	{
		if( !self::$aGlobalInstance )
		{
			self::$aGlobalInstance = new JCAT_Request(self::TYPE_DEFAULT,self::$sDefaultCLPP) ;
		}
		return self::$aGlobalInstance ;
	}
	
	/**
	 * get user quest param
	 *
	 * @access	public
	 * @param	$sParamName		string
	 * @return	string
	 */
	public function GetParam($sParamName)
	{
		foreach ($this->arrParamSources as $nType=>&$arrParamSource)
		{
			if( !($this->nRequestType&$nType) )
			{
				continue ;
			}
			
			if( array_key_exists($sParamName,$arrParamSource) )
			{
				return $nType===self::TYPE_CUS ?
					$arrParamSource[$sParamName] :
					$this->FilterMagicQuote($arrParamSource[$sParamName]) ;
			}
		}

		return null ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sParamName		string
	 * @return	int
	 */
	public function GetInt($sParamName)
	{
		return intval($this->GetParam($sParamName)) ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @return	string
	 */
	private function FilterMagicQuote($Data)
	{
		if( get_magic_quotes_gpc() )
		{
			if( is_string($Data) )
			{
				return stripslashes($Data) ;
			}
			
			else if( is_array($Data) )
			{
				foreach ($Data as $nIdx=>$Item)
				{
					$Data[$nIdx] = $this->FilterMagicQuote($Item) ;
				}
				
				return $Data ;
			}
		}
		

		return $Data ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function SetParam($sParamName,$Data)
	{
		$this->arrCusParams[$sParamName] = $Data ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sParamName		string
	 * @return	void
	 */
	public function RemoveParam($sParamName,$nParamType=self::TYPE_PARAM)
	{
		foreach ($this->arrParamSources as $nType=>&$arrParamSource)
		{
			if( $nType&$nParamType )
			{
				unset($arrParamSource[$sParamName]) ;
			}
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	bool
	 */
	static public function IsHTTPRequest()
	{
		return !empty($_SERVER['HTTP_HOST']) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sParamName='controller'		string
	 * @return	string
	 */
	public function GetRequestController($sParamName='controller')
	{
		$sControllerName = $this->GetParam($sParamName) ;
		
		if( !$sControllerName and defined($sControllerName) )
		{
			JCAT_ASSERT::ASSERT_ISCLASS(self::$sDefaultControllerClass,array('JCAT_IController')
						, "JCAT_Request::\$sDefaultControllerClass(%s) 必须是一个 JCAT_IController 类名。");
			
			$sControllerName = self::$sDefaultControllerClass ;
		}
		
		return $sControllerName ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateParamIterator()
	{
		$arrParamNames = array() ;
		foreach ($this->arrParamSources as $nType=>&$arrParamSource)
		{
			if( !($this->nRequestType&$nType) )
			{
				continue ;
			}
			
			$arrParamNames = array_merge($arrParamNames,array_keys($arrParamSource)) ;
		}
		
		return new JCAT_ArrayIterator( array_unique($arrParamNames) ) ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	array
	 */
	static public function GetCommandLineParams()
	{
		global $argv ;
		$arrArgvs = is_array($argv)?$argv: array() ;
		array_shift($arrArgvs) ;
		
		return array_values($arrArgvs) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param 	$nMakeFlag=MAKEURL_DEFAULT		int
	 * @param 	$arrExcludes=array()				array
	 * @return	string
	 */
	public function MakeUrl($nMakeFlag=self::MAKEURL_DEFAULT,array $arrExcludes=array())
	{
		
		$sUrl = '' ;
		
		if( ($nMakeFlag&self::MAKEURL_HOST) and $this->GetParam('HTTP_HOST') )
		{
			$sUrl.= "http://" . $this->GetParam('HTTP_HOST') ;
		}
	
		
		if( ($nMakeFlag&self::MAKEURL_PATH) and $this->GetParam('SCRIPT_NAME') )
		{
			$sUrl.= $this->GetParam('SCRIPT_NAME') ;
		}
	
		if( $nMakeFlag&self::TYPE_ALL )
		{
			$sUrl.= '?' ;
			
			$arrParams = array() ;
			foreach ($this->arrParamSources as $nType=>&$arrParamSource)
			{
				if( !($nType&$nMakeFlag) or !($this->nRequestType&$nType) )
				{
					continue ;
				}
				
				$arrParams = array_merge($arrParams,$arrParamSource) ;
			}
			
			// 排除指定的参数
			$arrExcludes = array_fill_keys($arrExcludes,0) ;
			$arrParams = array_diff_key($arrParams,$arrExcludes) ;
			
			if( count($arrParams) )
			{
				$sQuery = JCAT_Global::Array2UrlQeruy($arrParams) ;
				$sUrl.= $sQuery ;
			}
		}
		
		return $sUrl ;
	}
	
	
	/**
	 * 对象属性 nRequestType
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nRequestType = self::TYPE_DEFAULT ;
	
	/**
	 * Description
	 * 
	 * @access	public
	 * @static
	 * @var		string
	 */
	static public $sDefaultCLPP = 'JCAT_CLPP_NamedParamStyle' ;
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		JCAT_ResultDispatcher
	 */
	static private $aGlobalInstance ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrCLParams = array() ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrCusParams = array() ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrParamSources ;
	
	/**
	 * Description
	 * @static
	 * @access	public
	 * @var		string
	 */
	static public $sDefaultControllerClass = null ;
}

?>